/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.servlet;

import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;

public class HtmlTemplate {
    private String content;
    private List<String> templateFieldNames;
    private List<String> parts = new ArrayList<String>();
    private Map<String, Integer> fieldPartIndexes = new HashMap<String, Integer>();

    public HtmlTemplate(String content) {
        this.content = content;
    }

    public void setTemplateFields(String ... templateFieldNames) {
        this.templateFieldNames = Arrays.asList(templateFieldNames);
    }

    public void compile() {
        TreeMap<Integer, String> offsets = new TreeMap<Integer, String>();
        for (String fieldName : this.templateFieldNames) {
            int index = this.content.indexOf("\"{" + fieldName + "}\"");
            if (index == -1) {
                throw new IllegalArgumentException("Template field '" + fieldName + "' not found in template.");
            }
            offsets.put(index + 1, fieldName);
        }
        Map.Entry lastEntry = null;
        for (Map.Entry entry : offsets.entrySet()) {
            int beginOffset = 0;
            if (lastEntry != null) {
                beginOffset = (Integer)lastEntry.getKey() + ((String)lastEntry.getValue()).length() + 2;
            }
            this.parts.add(this.content.substring(beginOffset, (Integer)entry.getKey()));
            this.parts.add("");
            this.fieldPartIndexes.put((String)entry.getValue(), this.parts.size() - 1);
            lastEntry = entry;
        }
        if (lastEntry != null) {
            this.parts.add(this.content.substring((Integer)lastEntry.getKey() + ((String)lastEntry.getValue()).length() + 2));
        }
    }

    public Builder createBuilder() {
        return new Builder();
    }

    public class Builder {
        private ArrayList<String> partsCopy;

        public Builder() {
            this.partsCopy = new ArrayList<String>(HtmlTemplate.this.parts);
        }

        public void setFieldValue(String name, String value) {
            Integer fieldPartIndex = HtmlTemplate.this.fieldPartIndexes.get(name);
            if (fieldPartIndex == null) {
                throw new IllegalArgumentException("Unknown field name '" + name + "'.");
            }
            if (value == null) {
                value = "";
            }
            value = HTTPUtils.htmlEncode(value, true);
            this.partsCopy.set(fieldPartIndex, value);
        }

        public String build() throws IOException {
            StringBuilder builder = new StringBuilder();
            this.build(builder);
            return builder.toString();
        }

        public StringBuilder build(StringBuilder builder) throws IOException {
            for (String part : this.partsCopy) {
                builder.append(part);
            }
            return builder;
        }

        public void build(ServletOutputStream output) throws IOException {
            for (String part : this.partsCopy) {
                output.print(part);
            }
        }
    }
}

