/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.servlet;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthErrorResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractOAuthServlet
extends HttpServlet {
    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res);
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.doProcessRequest(req, res);
        }
        catch (OAuthErrorException exception) {
            Trace.logError(this, "OAuth revoke request exception: " + exception.getMessage());
            this.processException(req, res, exception);
        }
    }

    protected void processException(HttpServletRequest req, HttpServletResponse res, OAuthErrorException exception) throws ServletException, IOException {
        OAuthErrorResponse.build(exception).reply(res);
    }

    protected OAuthTokenProvider getProvider() {
        return (OAuthTokenProvider)this.getServletContext().getAttribute(OAuthTokenProvider.ATTRIBUTE);
    }

    protected abstract void doProcessRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException, OAuthErrorException;
}

