/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.response;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletResponse;

public abstract class OAuthResponse {
    protected int responseStatus;
    protected Object responseObject;
    protected String redirectURI = null;
    protected ResponseFormat responseFormat = ResponseFormat.JSON;

    protected OAuthResponse() {
        this.responseStatus = 200;
    }

    protected OAuthResponse(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public OAuthResponse setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public OAuthResponse setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public OAuthResponse setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public void reply(HttpServletResponse response) throws IOException {
        if (this.redirectURI != null && this.redirectURI.length() > 0 && (this.responseFormat == ResponseFormat.QUERY || this.responseFormat == ResponseFormat.FRAGMENT)) {
            Object uri = this.redirectURI;
            uri = this.responseFormat == ResponseFormat.QUERY ? (String)uri + "?" : (String)uri + "#";
            uri = (String)uri + this.queryResponse();
            response.sendRedirect((String)uri);
        } else {
            response.setStatus(this.responseStatus);
            if (this.responseFormat == ResponseFormat.JSON) {
                response.setContentType("application/json; charset=UTF-8");
                response.getOutputStream().write(this.jsonResponse().getBytes());
                response.flushBuffer();
            } else {
                response.setContentType("application/json; charset=UTF-8");
                response.getOutputStream().write(this.queryResponse().getBytes());
                response.flushBuffer();
            }
        }
    }

    public String jsonResponse() {
        try {
            return OAuthUtils.getJsonSerializer().serialize(this.responseObject);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            return "";
        }
    }

    public String queryResponse() {
        QueryParametersBuilder builder = new QueryParametersBuilder();
        this.buildResponse(builder);
        return builder.getResult().toString();
    }

    public String headerResponse() {
        HeaderParametersBuilder builder = new HeaderParametersBuilder();
        this.buildResponse(builder);
        return builder.getResult().toString();
    }

    protected void buildResponse(ParametersBuilder builder) {
        try {
            for (Field field : this.responseObject.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(this.responseObject);
                if (value == null) continue;
                builder.append(field.getName(), value);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    public static enum ResponseFormat {
        XML,
        JSON,
        QUERY,
        FRAGMENT;

    }

    static class QueryParametersBuilder
    extends AbstractParametersBuilder {
        QueryParametersBuilder() {
        }

        @Override
        public void append(String name, Object value) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(name).append("=").append(value);
        }
    }

    static interface ParametersBuilder {
        public void append(String var1, Object var2);
    }

    static class HeaderParametersBuilder
    extends AbstractParametersBuilder {
        HeaderParametersBuilder() {
        }

        @Override
        public void append(String name, Object value) {
            if (this.builder.length() > 0) {
                this.builder.append(", ");
            }
            this.builder.append(name).append("=").append(HeaderParametersBuilder.valueToStringWithQuotes(value));
        }
    }

    static abstract class AbstractParametersBuilder
    implements ParametersBuilder {
        protected StringBuilder builder = new StringBuilder();

        AbstractParametersBuilder() {
        }

        public static String valueToStringWithQuotes(Object value) {
            if (value instanceof String) {
                return "\"" + (String)value + "\"";
            }
            if (value instanceof Boolean) {
                return value.toString();
            }
            return value.toString();
        }

        public String getResult() {
            return this.builder.toString();
        }
    }
}

