/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.response;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.ResponseType;

public class OAuthErrorResponse
extends OAuthResponse {
    public OAuthErrorResponse() {
        super(400);
    }

    public OAuthErrorResponse(int responseStatus) {
        super(responseStatus);
    }

    public static OAuthErrorResponse build(OAuthErrorException exception) {
        OAuthErrorResponse result = new OAuthErrorResponse();
        result.responseStatus = 400;
        ResponseObject responseData = new ResponseObject();
        responseData.error = exception.getError();
        responseData.error_description = exception.getDescription();
        responseData.error_uri = exception.getErrorUri();
        result.responseObject = responseData;
        result.redirectURI = exception.getRedirectUri();
        if (result.redirectURI != null) {
            if (exception.getResponseType() == ResponseType.CODE) {
                result.responseFormat = OAuthResponse.ResponseFormat.QUERY;
            } else if (exception.getResponseType() == ResponseType.TOKEN) {
                result.responseFormat = OAuthResponse.ResponseFormat.FRAGMENT;
            }
        }
        return result;
    }

    public static class ResponseObject {
        public String error = null;
        public String error_description = null;
        public String error_uri = null;
    }
}

