/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.request;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.GrantType;
import javax.servlet.http.HttpServletRequest;

public class OAuthTokenRequest
extends OAuthRequest {
    public OAuthTokenRequest(HttpServletRequest request) throws OAuthErrorException {
        super(request);
    }

    @Override
    protected void onValidate() throws OAuthErrorException {
        String grantType = this.getParam("grant_type");
        if (OAuthUtils.isEmpty(grantType)) {
            throw OAuthUtils.handleOAuthErrorException("Missing grant_type parameter value");
        }
        this.validateGrantType(grantType);
    }

    private void validateGrantType(String type) throws OAuthErrorException {
        GrantType grantType = GrantType.parse(type);
        if (grantType == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid grant_type parameter value: " + type);
        }
        if (grantType == GrantType.AUTHORIZATION_CODE) {
            this.validateParameterNotEmpty("grant_type");
            this.validateParameterNotEmpty("client_id");
            this.validateParameterNotEmpty("code");
            this.validateParameterNotEmpty("redirect_uri");
        } else if (grantType == GrantType.PASSWORD) {
            this.validateParameterNotEmpty("grant_type");
            this.validateParameterNotEmpty("client_id");
            this.validateParameterNotEmpty("username");
            this.validateParameterNotEmpty("password");
        } else if (grantType == GrantType.REFRESH_TOKEN) {
            this.validateParameterNotEmpty("grant_type");
            this.validateParameterNotEmpty("client_id");
            this.validateParameterNotEmpty("refresh_token");
        } else if (grantType == GrantType.CLIENT_CREDENTIALS) {
            throw new OAuthErrorException("unsupported_grant_type", "Unsupported grant_type: " + type);
        }
    }

    public String getPassword() {
        return this.getParam("password");
    }

    public String getUsername() {
        return this.getParam("username");
    }

    @Override
    public String getCode() {
        return this.getParam("code");
    }

    public GrantType getGrantType() {
        return GrantType.parse(this.getParam("grant_type"));
    }
}

