/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.request;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.ResponseType;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class OAuthRequest {
    protected HttpServletRequest request;

    public OAuthRequest(HttpServletRequest request) throws OAuthErrorException {
        this.request = request;
        this.validate();
    }

    protected void validate() throws OAuthErrorException {
        try {
            this.onValidateMethod();
            this.onValidateContentType();
            this.onValidate();
        }
        catch (OAuthErrorException e) {
            String redirectUri = this.request.getParameter("redirect_uri");
            if (!OAuthUtils.isEmpty(redirectUri)) {
                e.setRedirectUri(redirectUri);
            }
            e.setResponseType(this.getResponseType());
            throw e;
        }
    }

    protected void onValidateMethod() throws OAuthErrorException {
    }

    protected void onValidateContentType() throws OAuthErrorException {
    }

    protected abstract void onValidate() throws OAuthErrorException;

    protected void validateParameterPresense(String name) throws OAuthErrorException {
        if (OAuthUtils.isNull(this.getParam(name))) {
            throw OAuthUtils.handleOAuthErrorException("Missing parameter " + name + ".");
        }
    }

    protected void validateParameterNotEmpty(String name) throws OAuthErrorException {
        if (OAuthUtils.isEmpty(this.getParam(name))) {
            throw OAuthUtils.handleOAuthErrorException("Missing parameter " + name + ".");
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    public String getClientId() {
        return this.getParam("client_id");
    }

    public String getRedirectURI() {
        return this.getParam("redirect_uri");
    }

    public String getClientSecret() {
        return this.getParam("client_secret");
    }

    public Set<String> getScopes() {
        String scopes = this.getParam("scope");
        return OAuthUtils.decodeScopes(scopes);
    }

    public String getCode() {
        return this.getParam("code");
    }

    public ResponseType getResponseType() {
        return ResponseType.parse(this.getParam("response_type"));
    }

    public String getState() {
        return this.getParam("state");
    }
}

