/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.request;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.DisplayType;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.ResponseType;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class OAuthAuthorizeRequest
extends OAuthRequest {
    public OAuthAuthorizeRequest(HttpServletRequest request) throws OAuthErrorException {
        super(request);
    }

    @Override
    protected void onValidateMethod() throws OAuthErrorException {
        if (!this.request.getMethod().equals("GET")) {
            throw OAuthUtils.handleOAuthErrorException("Method not set to GET.");
        }
    }

    @Override
    protected void onValidate() throws OAuthErrorException {
        String responseType = this.getParam("response_type");
        if (OAuthUtils.isEmpty(responseType)) {
            throw OAuthUtils.handleOAuthErrorException("Missing response_type parameter value");
        }
        this.validateResponseType(responseType);
    }

    private void validateResponseType(String type) throws OAuthErrorException {
        ResponseType responseType = ResponseType.parse(type);
        if (responseType == null) {
            throw new OAuthErrorException("unsupported_response_type", "Invalid response_type parameter value: " + type);
        }
        if (responseType == ResponseType.CODE) {
            this.validateParameterNotEmpty("response_type");
            this.validateParameterNotEmpty("client_id");
            this.validateParameterNotEmpty("redirect_uri");
        } else if (responseType == ResponseType.TOKEN) {
            this.validateParameterNotEmpty("response_type");
            this.validateParameterNotEmpty("client_id");
            this.validateParameterNotEmpty("redirect_uri");
        } else {
            throw new OAuthErrorException("unsupported_response_type", "Unsupported grant_type: " + type);
        }
    }

    public DisplayType getDisplayType() {
        DisplayType type = DisplayType.parse(this.getParam("display"));
        if (type == null) {
            return DisplayType.PAGE;
        }
        return type;
    }

    public String getQueryStringForPage() {
        StringBuilder builder = new StringBuilder();
        Enumeration<String> names = this.request.getParameterNames();
        while (names != null && names.hasMoreElements()) {
            String name = names.nextElement();
            if (name.equalsIgnoreCase("display")) {
                builder.append("display=page");
            } else {
                builder.append(name).append("=").append(this.request.getParameter(name));
            }
            builder.append("&");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }
}

