/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2;

import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class OAuthUtils {
    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        if (OAuthUtils.isEmpty(requiredContentType) || OAuthUtils.isEmpty(requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!OAuthUtils.isEmpty(s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean isNull(String value) {
        return value == null;
    }

    public static boolean equals(String value1, String value2) {
        return value1 == null && value2 == null || value1 != null && value2 != null && value1.equals(value2);
    }

    public static boolean equalsIgnoreCase(String value1, String value2) {
        return value1 == null && value2 == null || value1 != null && value2 != null && value1.equalsIgnoreCase(value2);
    }

    public static OAuthErrorException handleOAuthErrorException(String message) {
        return new OAuthErrorException("invalid_request", message);
    }

    public static synchronized JSONSerializer getJsonSerializer() {
        return JSONSerializerFactory.getInstance().createSerializerDefaultBuilderLazy("OAuthJsonSerializer").apply(builder -> {
            builder.setJsonNotation(JsonNotation.TYPE);
            builder.setJsonNotationLevel(JsonNotationLevel.NONE);
            builder.setPrettyPrint(true);
            builder.setSkipNulls(true);
        }).getOrBuild();
    }
}

