/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthAccessToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthCode;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthRefreshToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthAuthenticateRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthTokenRequest;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviders;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class OAuthTokenProvider {
    public static final String ATTRIBUTE = OAuthTokenProvider.class.getName();
    private HTTPAcceptorConfiguration configuration;
    private FabricConnectionsProviders fabricConnectionsProviders;
    private Map<String, OAuthAccessToken> tokens = new ConcurrentHashMap<String, OAuthAccessToken>();
    private Map<String, OAuthCode> codes = new ConcurrentHashMap<String, OAuthCode>();
    private Map<String, OAuthRefreshToken> refreshTokens = new ConcurrentHashMap<String, OAuthRefreshToken>();

    public void setConfiguration(HTTPAcceptorConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setFabricConnectionsProviders(FabricConnectionsProviders fabricConnectionsProviders) {
        this.fabricConnectionsProviders = fabricConnectionsProviders;
    }

    public OAuthAccessToken createTokenByPasswordGrant(OAuthTokenRequest request) throws OAuthErrorException {
        OAuthAccessToken token = this.createToken(request.getUsername(), request.getPassword(), request.getClientId());
        this.threadSafeTokenPutWithCountCheck(token);
        this.createRefreshTokenFor(token);
        return token;
    }

    public OAuthAccessToken createTokenByTokenRequest(OAuthAuthenticateRequest request) throws OAuthErrorException {
        OAuthAccessToken token = this.createToken(request.getUsername(), request.getPassword(), request.getClientId());
        token.setState(request.getState());
        this.threadSafeTokenPutWithCountCheck(token);
        return token;
    }

    public OAuthCode createCode(OAuthAuthenticateRequest request) throws OAuthErrorException {
        OAuthAccessToken token = this.createToken(request.getUsername(), request.getPassword(), request.getClientId());
        token.setState(request.getState());
        OAuthCode code = new OAuthCode(OAuthTokenProvider.generateCodeValue(), 30L);
        code.setToken(token);
        code.setRedirectUri(request.getRedirectURI());
        this.codes.put(code.getCode(), code);
        Trace.logInfo(this, "oauth code created: " + String.valueOf(code) + ", codes count: " + this.codes.size());
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthAccessToken createTokenByCodeGrant(OAuthCode code) throws OAuthErrorException {
        OAuthCode oAuthCode = code;
        synchronized (oAuthCode) {
            if (code.isExpired()) {
                throw new OAuthErrorException("invalid_client", "code is invalid or expired.");
            }
            OAuthAccessToken token = code.getToken();
            token.setLastAccessTime();
            this.threadSafeTokenPutWithCountCheck(token);
            this.createRefreshTokenFor(token);
            code.setExpiresIn(-1L);
            this.codes.remove(code);
            Trace.logInfo(this, "oauth code removed: " + String.valueOf(code) + ", codes count: " + this.codes.size());
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthAccessToken createTokenByRefreshTokenGrant(OAuthRefreshToken refreshToken) throws OAuthErrorException {
        OAuthRefreshToken oAuthRefreshToken = refreshToken;
        synchronized (oAuthRefreshToken) {
            refreshToken.getAccessToken().setExpiresIn(-1L);
            OAuthAccessToken accessToken = this.createToken(refreshToken.getAccessToken().getUsername(), refreshToken.getAccessToken().getPassword(), refreshToken.getAccessToken().getClientId());
            accessToken.setScope(refreshToken.getAccessToken().getScope());
            accessToken.setRefreshToken(refreshToken.getRefreshToken());
            accessToken.setLastAccessTime();
            refreshToken.setAccessToken(accessToken);
            this.tokens.put(accessToken.getAccessToken(), accessToken);
            Trace.logInfo(this, "oauth access token created: " + String.valueOf(accessToken) + ", access tokens count: " + this.tokens.size());
            return accessToken;
        }
    }

    public OAuthAccessToken getAccessToken(String token) {
        OAuthAccessToken oauthToken = this.tokens.get(token);
        if (oauthToken == null) {
            return null;
        }
        if (!oauthToken.isExpired()) {
            oauthToken.setLastAccessTime();
        }
        return oauthToken;
    }

    public OAuthCode getCode(String code) {
        return this.codes.get(code);
    }

    public OAuthRefreshToken getRefreshToken(String token) {
        return this.refreshTokens.get(token);
    }

    protected OAuthAccessToken createToken(String username, String password, String client_id) {
        OAuthAccessToken token = new OAuthAccessToken(OAuthTokenProvider.generateAccessTokenValue(), this.configuration.getSessionTimeout() * 60);
        token.setUsername(username);
        token.setPassword(password);
        token.setClientId(client_id);
        token.setTokenType("Bearer");
        token.setRefreshToken(null);
        return token;
    }

    protected void createRefreshTokenFor(OAuthAccessToken accessToken) {
        if (accessToken.getRefreshToken() == null) {
            accessToken.setRefreshToken(OAuthTokenProvider.generateRefreshTokenValue());
        }
        this.threadSafeRefreshTokenPutWithCountCheck(new OAuthRefreshToken(accessToken.getRefreshToken(), accessToken));
    }

    public void removeExpired() {
        this.removeExpiredTokens();
        this.removeExpiredCodes();
        this.removeExpiredRefreshTokens();
    }

    public void removeExpiredTokens() {
        Iterator<Map.Entry<String, OAuthAccessToken>> iterator = this.tokens.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OAuthAccessToken> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            for (String sessionId : entry.getValue().getSessionIds()) {
                this.fabricConnectionsProviders.removeConnection(sessionId, true);
            }
            iterator.remove();
            Trace.logInfo(this, "oauth access token expired removed: " + String.valueOf(entry.getValue()) + ", tokens count: " + this.tokens.size());
        }
    }

    public void removeExpiredRefreshTokens() {
        Iterator<Map.Entry<String, OAuthRefreshToken>> iterator = this.refreshTokens.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OAuthRefreshToken> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            iterator.remove();
            Trace.logInfo(this, "oauth refresh token expired removed: " + String.valueOf(entry.getValue()) + ", refresh tokens count: " + this.refreshTokens.size());
        }
    }

    public void removeExpiredCodes() {
        Iterator<Map.Entry<String, OAuthCode>> iterator = this.codes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OAuthCode> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            iterator.remove();
            Trace.logInfo(this, "oauth code expired removed: " + String.valueOf(entry.getValue()) + ", codes count: " + this.codes.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void threadSafeTokenPutWithCountCheck(OAuthAccessToken token) throws OAuthErrorException {
        Map<String, OAuthAccessToken> map = this.tokens;
        synchronized (map) {
            this.checkTokensCount();
            this.tokens.put(token.getAccessToken(), token);
            Trace.logInfo(this, "oauth access token created: " + String.valueOf(token) + ", access tokens count: " + this.tokens.size());
        }
    }

    protected void checkTokensCount() throws OAuthErrorException {
        if (this.configuration.getMaxActiveSessionsNumber() > 0 && this.tokens.size() >= this.configuration.getMaxActiveSessionsNumber()) {
            Trace.logError(this, "Tokens limit is reached, tokens count: " + this.tokens.size() + ", limit: " + this.configuration.getMaxActiveSessionsNumber());
            throw new OAuthErrorException("invalid_request", "Tokens limit reached.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void threadSafeRefreshTokenPutWithCountCheck(OAuthRefreshToken token) {
        Map<String, OAuthRefreshToken> map = this.refreshTokens;
        synchronized (map) {
            if (!this.isRefreshTokensLimitReached()) {
                // empty if block
            }
            this.refreshTokens.put(token.getRefreshToken(), token);
            Trace.logInfo(this, "oauth refresh token created: " + String.valueOf(token) + ", refresh tokens count: " + this.refreshTokens.size());
        }
    }

    protected boolean isRefreshTokensLimitReached() {
        if (this.configuration.getMaxActiveSessionsNumber() > 0 && this.refreshTokens.size() >= this.configuration.getMaxActiveSessionsNumber()) {
            Trace.logError(this, "Refresh tokens limit is reached, refresh tokens count: " + this.refreshTokens.size() + ", limit: " + this.configuration.getMaxActiveSessionsNumber());
            return true;
        }
        return false;
    }

    public static boolean isAccessToken(String token) {
        return token != null && token.startsWith("at");
    }

    public static boolean isCode(String code) {
        return code != null && code.startsWith("co");
    }

    public static boolean isRefreshToken(String token) {
        return token != null && token.startsWith("rt");
    }

    public static String generateAccessTokenValue() {
        return "at" + OAuthTokenProvider.generateValue();
    }

    public static String generateCodeValue() {
        return "co" + OAuthTokenProvider.generateValue();
    }

    public static String generateRefreshTokenValue() {
        return "rt" + OAuthTokenProvider.generateValue();
    }

    public static String generateValue() {
        return OAuthTokenProvider.generateValue(UUID.randomUUID().toString());
    }

    public static String generateValue(String param) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(param.getBytes());
            byte[] messageDigest = algorithm.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException exception) {
            Trace.logError(OAuthUtils.class, "Failed to generate OAuth token: " + exception.getMessage());
            throw new RuntimeException(exception);
        }
    }
}

