/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.ResponseType;

public class OAuthErrorException
extends Exception {
    private String error;
    private String description;
    private String errorUri;
    private transient String redirectUri = null;
    private transient ResponseType responseType = null;

    public OAuthErrorException(String error) {
        this(error, null, null);
    }

    public OAuthErrorException(String error, String description) {
        this(error, description, null);
    }

    public OAuthErrorException(String error, String description, String errorUri) {
        this(error, description, errorUri, null, null);
    }

    public OAuthErrorException(String error, String description, String errorUri, String redirectUri, ResponseType responseType) {
        this.error = error;
        this.description = description;
        this.errorUri = errorUri;
        this.redirectUri = redirectUri;
        this.setResponseType(responseType);
    }

    public String getError() {
        return this.error;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder();
        if (!OAuthUtils.isEmpty(this.error)) {
            b.append(this.error);
        }
        if (!OAuthUtils.isEmpty(this.description)) {
            b.append(", ").append(this.description);
        }
        if (!OAuthUtils.isEmpty(this.errorUri)) {
            b.append(", ").append(this.errorUri);
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "OAuthErrorException{error='" + this.error + "', description='" + this.description + "', errorUri='" + this.errorUri + "'}";
    }
}

