/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2;

import com.streamscape.sef.network.http.server.authentication.ExpiredObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class OAuthAccessToken
extends ExpiredObject {
    private String accessToken;
    private String tokenType;
    private String refreshToken;
    private String scope;
    private String clientId;
    private String state;
    private String username;
    private String password;
    private Set<String> sessionIds = new TreeSet<String>();

    public OAuthAccessToken(String accessToken, long expiresIn) {
        super(expiresIn);
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public synchronized String setAndGetSessionId(String sessionId) {
        if (this.sessionIds.contains(sessionId)) {
            return sessionId;
        }
        if (this.sessionIds.size() > 0) {
            return this.sessionIds.iterator().next();
        }
        this.sessionIds.add(sessionId);
        return sessionId;
    }

    public synchronized void addSessionId(String sessionId) {
        this.sessionIds.add(sessionId);
    }

    public synchronized Collection<String> getSessionIds() {
        return new ArrayList<String>(this.sessionIds);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return "OAuthAccessToken(accessToken: " + this.accessToken + ", tokenType: " + this.tokenType + ", refreshToken: " + this.refreshToken + ", scope: " + this.scope + ", sessionIds: " + String.valueOf(this.sessionIds) + ", " + super.toString() + ")";
    }
}

