/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt.algorithm;

import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSignatureVerificationException;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.CryptoHelper;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;

class RSAAlgorithm
extends JWTAlgorithm {
    private final CryptoHelper crypto;
    private final RSAPrivateKey privateKey;
    private final RSAPublicKey publicKey;

    RSAAlgorithm(String id, String algorithm, RSAPrivateKey privateKey, RSAPublicKey publicKey) throws IllegalArgumentException {
        super(id, algorithm);
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.crypto = new CryptoHelper();
    }

    @Override
    public void verify(JWTDecodedToken jwt) throws JWTSignatureVerificationException {
        byte[] signatureBytes = Base64.decodeBase64(jwt.getSignatureString());
        try {
            if (this.publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), (PublicKey)this.publicKey, jwt.getHeaderString(), jwt.getPayloadString(), signatureBytes);
            if (!valid) {
                throw new JWTSignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
        try {
            if (this.privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), this.privateKey, headerBytes, payloadBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTException("Failed to genrate signature.", e);
        }
    }
}

