/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt.algorithm;

import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSignatureVerificationException;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.ECDSAAlgorithm;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.HMACAlgorithm;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithmType;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.RSAAlgorithm;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;

public abstract class JWTAlgorithm {
    private final String name;
    private final String description;

    public static JWTAlgorithm create(JWTAlgorithmType algorithmType, SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) {
        switch (algorithmType) {
            case RSA256: {
                return new RSAAlgorithm("RS256", "SHA256withRSA", (RSAPrivateKey)privateKey, (RSAPublicKey)publicKey);
            }
            case RSA384: {
                return new RSAAlgorithm("RS384", "SHA256withRSA", (RSAPrivateKey)privateKey, (RSAPublicKey)publicKey);
            }
            case RSA512: {
                return new RSAAlgorithm("RS512", "SHA512withRSA", (RSAPrivateKey)privateKey, (RSAPublicKey)publicKey);
            }
            case HMAC256: {
                return new HMACAlgorithm("HS256", "HmacSHA256", secretKey);
            }
            case HMAC384: {
                return new HMACAlgorithm("HS384", "HmacSHA384", secretKey);
            }
            case HMAC512: {
                return new HMACAlgorithm("HS512", "HmacSHA512", secretKey);
            }
            case ECDSA256: {
                return new ECDSAAlgorithm("ES256", "SHA256withECDSA", 32, (ECPrivateKey)privateKey, (ECPublicKey)publicKey);
            }
            case ECDSA384: {
                return new ECDSAAlgorithm("ES384", "SHA384withECDSA", 48, (ECPrivateKey)privateKey, (ECPublicKey)publicKey);
            }
            case ECDSA512: {
                return new ECDSAAlgorithm("ES512", "SHA512withECDSA", 66, (ECPrivateKey)privateKey, (ECPublicKey)publicKey);
            }
        }
        throw new IllegalArgumentException("Invalid type.");
    }

    protected JWTAlgorithm(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public abstract void verify(JWTDecodedToken var1) throws JWTSignatureVerificationException;

    public abstract byte[] sign(byte[] var1, byte[] var2);
}

