/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt.algorithm;

import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSignatureVerificationException;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.CryptoHelper;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

class HMACAlgorithm
extends JWTAlgorithm {
    private final CryptoHelper crypto;
    private final SecretKey secretKey;

    HMACAlgorithm(String id, String algorithm, SecretKey secretKey) throws IllegalArgumentException {
        super(id, algorithm);
        this.secretKey = secretKey;
        this.crypto = new CryptoHelper();
    }

    @Override
    public void verify(JWTDecodedToken jwt) throws JWTSignatureVerificationException {
        byte[] signatureBytes = Base64.decodeBase64(jwt.getSignatureString());
        try {
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), this.secretKey.getEncoded(), jwt.getHeaderString(), jwt.getPayloadString(), signatureBytes);
            if (!valid) {
                throw new JWTSignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTSignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
        try {
            return this.crypto.createSignatureFor(this.getDescription(), this.secretKey.getEncoded(), headerBytes, payloadBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTException("Failed to genrate signature.", e);
        }
    }
}

