/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt.algorithm;

import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSignatureVerificationException;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.CryptoHelper;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.apache.commons.codec.binary.Base64;

class ECDSAAlgorithm
extends JWTAlgorithm {
    private final CryptoHelper crypto;
    private final int ecNumberSize;
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;

    ECDSAAlgorithm(String id, String algorithm, int ecNumberSize, ECPrivateKey privateKey, ECPublicKey publicKey) throws IllegalArgumentException {
        super(id, algorithm);
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.crypto = new CryptoHelper();
        this.ecNumberSize = ecNumberSize;
    }

    @Override
    public void verify(JWTDecodedToken jwt) throws JWTSignatureVerificationException {
        byte[] signatureBytes = Base64.decodeBase64(jwt.getSignatureString());
        try {
            if (this.publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), (PublicKey)this.publicKey, jwt.getHeaderString(), jwt.getPayloadString(), this.JOSEToDER(signatureBytes));
            if (!valid) {
                throw new JWTSignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
        try {
            if (this.privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            byte[] signature = this.crypto.createSignatureFor(this.getDescription(), this.privateKey, headerBytes, payloadBytes);
            return this.DERToJOSE(signature);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTException("Failed to genrate signature.", e);
        }
    }

    byte[] DERToJOSE(byte[] derSignature) throws SignatureException {
        int encodedLength;
        boolean derEncoded;
        boolean bl = derEncoded = derSignature[0] == 48 && derSignature.length != this.ecNumberSize * 2;
        if (!derEncoded) {
            throw new SignatureException("Invalid DER signature format.");
        }
        byte[] joseSignature = new byte[this.ecNumberSize * 2];
        int offset = 1;
        if (derSignature[1] == -127) {
            // empty if block
        }
        if ((encodedLength = derSignature[++offset] & 0xFF) != derSignature.length - ++offset) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int n = ++offset;
        ++offset;
        byte rLength = derSignature[n];
        if (rLength > this.ecNumberSize + 1) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int rPadding = this.ecNumberSize - rLength;
        System.arraycopy(derSignature, offset + Math.max(-rPadding, 0), joseSignature, Math.max(rPadding, 0), rLength + Math.min(rPadding, 0));
        offset += rLength + 1;
        byte sLength = derSignature[offset++];
        if (sLength > this.ecNumberSize + 1) {
            throw new SignatureException("Invalid DER signature format.");
        }
        int sPadding = this.ecNumberSize - sLength;
        System.arraycopy(derSignature, offset + Math.max(-sPadding, 0), joseSignature, this.ecNumberSize + Math.max(sPadding, 0), sLength + Math.min(sPadding, 0));
        return joseSignature;
    }

    byte[] JOSEToDER(byte[] joseSignature) throws SignatureException {
        int offset;
        byte[] derSignature;
        int sPadding;
        int sLength;
        if (joseSignature.length != this.ecNumberSize * 2) {
            throw new SignatureException("Invalid JOSE signature format.");
        }
        int rPadding = this.countPadding(joseSignature, 0, this.ecNumberSize);
        int rLength = this.ecNumberSize - rPadding;
        int length = 2 + rLength + 2 + (sLength = this.ecNumberSize - (sPadding = this.countPadding(joseSignature, this.ecNumberSize, joseSignature.length)));
        if (length > 255) {
            throw new SignatureException("Invalid JOSE signature format.");
        }
        if (length > 127) {
            derSignature = new byte[3 + length];
            derSignature[1] = -127;
            offset = 2;
        } else {
            derSignature = new byte[2 + length];
            offset = 1;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)(length & 0xFF);
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)rLength;
        if (rPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, 0, derSignature, offset, this.ecNumberSize);
            offset += this.ecNumberSize;
        } else {
            int copyLength = Math.min(this.ecNumberSize, rLength);
            System.arraycopy(joseSignature, rPadding, derSignature, offset, copyLength);
            offset += copyLength;
        }
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)sLength;
        if (sPadding < 0) {
            derSignature[offset++] = 0;
            System.arraycopy(joseSignature, this.ecNumberSize, derSignature, offset, this.ecNumberSize);
        } else {
            System.arraycopy(joseSignature, this.ecNumberSize + sPadding, derSignature, offset, Math.min(this.ecNumberSize, sLength));
        }
        return derSignature;
    }

    private int countPadding(byte[] bytes, int fromIndex, int toIndex) {
        int padding = 0;
        while (fromIndex + padding < toIndex && bytes[fromIndex + padding] == 0) {
            ++padding;
        }
        return (bytes[fromIndex + padding] & 0xFF) > 127 ? padding - 1 : padding;
    }
}

