/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class JWTPayload {
    @JsonProperty(value="iss")
    private String issuer;
    @JsonProperty(value="sub")
    private String subject;
    @JsonProperty(value="exp")
    private Long expiresAt;
    @JsonProperty(value="nbf")
    private Long notBefore;
    @JsonProperty(value="iat")
    private Long issuedAt = System.currentTimeMillis() / 1000L;
    @JsonProperty(value="jti")
    private String jwtId;
    @JsonProperty(value="aud")
    private String audience;
    @JsonProperty(value="res")
    private List<JWTResource> resources;

    public String getIssuer() {
        return this.issuer;
    }

    public JWTPayload setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public JWTPayload setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public Date getExpiresAtDate() {
        return this.expiresAt != null ? new Date(this.expiresAt * 1000L) : null;
    }

    public JWTPayload setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public JWTPayload setExpiresIn(Long expiresIn) {
        this.expiresAt = this.issuedAt + expiresIn;
        return this;
    }

    public JWTPayload setExpiresAt(Date date) {
        this.expiresAt = date != null ? Long.valueOf(date.getTime() / 1000L) : null;
        return this;
    }

    public Long getNotBefore() {
        return this.notBefore;
    }

    public JWTPayload setNotBefore(Long notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public Long getIssuedAt() {
        return this.issuedAt;
    }

    public JWTPayload setIssuedAt(Long issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public JWTPayload setJwtId(String jwtId) {
        this.jwtId = jwtId;
        return this;
    }

    public String getAudience() {
        return this.audience;
    }

    public JWTPayload setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public List<JWTResource> getResources() {
        return this.resources != null ? new ArrayList<JWTResource>(this.resources) : new ArrayList();
    }

    public JWTPayload setResources(Collection<JWTResource> resources) {
        this.resources = new ArrayList<JWTResource>(new HashSet<JWTResource>(resources));
        return this;
    }

    public static class JWTResource
    implements Application.ResourceBase {
        private String method;
        private String url;

        public JWTResource(String method, String url) {
            this.method = method;
            this.url = url;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        public JWTResource setMethod(String method) {
            this.method = method;
            return this;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public JWTResource setUrl(String url) {
            this.url = url;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JWTResource)) {
                return false;
            }
            JWTResource that = (JWTResource)o;
            return Objects.equals(this.method, that.method) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.url);
        }

        public String toString() {
            return this.method + " - " + this.url;
        }
    }
}

