/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyEntryProvider;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTHeader;
import com.streamscape.sef.network.http.server.authentication.jwt.SSSecurityKeyEntryProviderForJWT;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithm;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithmType;

public class JWTDecoder {
    private SSSecurityKeyEntryProvider ssSecurityKeyEntryProvider;
    private RuntimeContext context;

    public JWTDecoder setSSSecurityKeyEntryProvider(SSSecurityKeyEntryProvider ssSecurityKeyEntryProvider) {
        this.ssSecurityKeyEntryProvider = ssSecurityKeyEntryProvider;
        return this;
    }

    public JWTDecoder setContext(RuntimeContext context) {
        this.context = context;
        return this;
    }

    public JWTDecodedToken decode(String jwt) {
        return new JWTDecodedToken(jwt);
    }

    public void verify(JWTDecodedToken token) {
        SSSecurityKeyEntry entry;
        JWTHeader header = token.getHeader();
        SSSecurityKeyEntry sSSecurityKeyEntry = entry = this.ssSecurityKeyEntryProvider != null ? this.ssSecurityKeyEntryProvider.getEntryByUUID(header.getKeyId()) : new SSSecurityKeyEntryProviderForJWT(this.context).getEntryByUUID(header.getKeyId());
        if (entry == null) {
            throw new JWTException("Invalid keyId " + header.getKeyId());
        }
        JWTAlgorithmType algotithmType = null;
        try {
            algotithmType = JWTAlgorithmType.valueOf(new String(header.getAlgorithm()).toUpperCase());
        }
        catch (Exception exception) {
            throw new JWTException("Invalid alg type " + header.getAlgorithm());
        }
        JWTAlgorithm algorithm = JWTAlgorithm.create(algotithmType, entry.getSecretKey(), entry.getPrivateKey(), entry.getPublicKey());
        algorithm.verify(token);
        token.getPayload();
    }

    public JWTDecodedToken decodeAndVerify(String jwt) {
        JWTDecodedToken token = this.decode(jwt);
        this.verify(token);
        return token;
    }
}

