/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt;

import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTHeader;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTPayload;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSerializer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class JWTDecodedToken {
    private String[] parts;
    private JWTHeader header;
    private JWTPayload payload;

    JWTDecodedToken(String jwt) {
        String headerJson;
        this.parts = JWTDecodedToken.splitToken(jwt);
        try {
            headerJson = StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[0]));
        }
        catch (NullPointerException e) {
            throw new JWTException("The UTF-8 Charset isn't initialized.", e);
        }
        this.header = (JWTHeader)JWTSerializer.deserialize(JWTHeader.class, headerJson);
    }

    public String getHeaderString() {
        return this.parts[0];
    }

    public String getPayloadString() {
        return this.parts[1];
    }

    public String getHeaderJson() {
        return StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[0]));
    }

    public String getPayloadJson() {
        return StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[1]));
    }

    public String getSignatureString() {
        return this.parts[2];
    }

    public void deserializePayload() {
        String payloadJson;
        if (this.payload != null) {
            return;
        }
        try {
            payloadJson = StringUtils.newStringUtf8(Base64.decodeBase64(this.parts[1]));
        }
        catch (NullPointerException e) {
            throw new JWTException("The UTF-8 Charset isn't initialized.", e);
        }
        this.payload = (JWTPayload)JWTSerializer.deserialize(JWTPayload.class, payloadJson);
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    public JWTPayload getPayload() {
        this.deserializePayload();
        return this.payload;
    }

    static String[] splitToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new JWTException(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }
}

