/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt;

import com.streamscape.ds.session.Session;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.keys.SSSecurityKeyAlgorithm;
import com.streamscape.sef.keys.SSSecurityKeyEntry;
import com.streamscape.sef.keys.SSSecurityKeyEntryProvider;
import com.streamscape.sef.keys.SSSecurityKeyException;
import com.streamscape.sef.keys.SSSecurityKeyGenerator;
import com.streamscape.sef.network.http.server.authentication.jwt.JWT;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTException;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTHeader;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTPayload;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTSerializer;
import com.streamscape.sef.network.http.server.authentication.jwt.SSSecurityKeyEntryProviderForJWT;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithm;
import com.streamscape.sef.network.http.server.authentication.jwt.algorithm.JWTAlgorithmType;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class JWTBuilder {
    private JWTAlgorithmType jwtAlgorithmType;
    private String keyName;
    private SSSecurityKeyEntryProvider securityKeyEntryProvider;
    private JWTPayload payload;
    private RuntimeContext context;

    JWTBuilder() {
    }

    public JWTAlgorithmType getJwtAlgorithmType() {
        return this.jwtAlgorithmType;
    }

    public JWTBuilder setJwtAlgorithmType(JWTAlgorithmType jwtAlgorithmType) {
        this.jwtAlgorithmType = jwtAlgorithmType;
        return this;
    }

    public JWTBuilder setSecurityKeyEntryProvider(SSSecurityKeyEntryProvider securityKeyEntryProvider) {
        this.securityKeyEntryProvider = securityKeyEntryProvider;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public JWTBuilder setKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    public JWTBuilder setPayload(JWTPayload payload) {
        this.payload = payload;
        return this;
    }

    public String buildToken(MFSession session) {
        return this.buildTokenInternal(session.getOwnerName(), true);
    }

    public String buildToken(Session session) {
        return this.buildTokenInternal(session.getUsername(), true);
    }

    private String buildTokenInternal(String username, boolean checkUser) {
        SSSecurityKeyEntry entry;
        SSSecurityKeyEntry sSSecurityKeyEntry = entry = this.securityKeyEntryProvider == null ? new SSSecurityKeyEntryProviderForJWT(this.context).getEntryByName(this.keyName) : this.securityKeyEntryProvider.getEntryByName(this.keyName);
        if (entry == null) {
            throw new JWTException("Security Key with specified name not found.");
        }
        this.payload.setIssuer(username);
        if (checkUser) {
            try {
                User user = this.context.getSecurityManager().lookupUser(this.payload.getIssuer());
                if (user == null) {
                    throw new JWTException("Specified Issuer user doesn't exist.");
                }
                if (!(user == null || user.isAdministrator() || entry.isPublic() || entry.getOwnerName().equalsIgnoreCase(this.payload.getIssuer()))) {
                    throw new JWTException("Specified security key is not visible by current user.");
                }
            }
            catch (SecurityManagerException e) {
                throw new JWTException("Failed to get user.", e);
            }
        }
        if (this.jwtAlgorithmType.getSsKeyAlgorithm() != entry.getAlgorithm()) {
            throw new SSSecurityKeyException("Incompatible JWT and Security Key algorithm: " + this.jwtAlgorithmType.toString() + " and " + entry.getAlgorithm().toString());
        }
        JWTHeader header = new JWTHeader().setAlgorithm(this.jwtAlgorithmType.toString()).setKeyId(entry.getUUID()).setType("JWT");
        String headerJson = JWTSerializer.serialize(header);
        String payloadJson = JWTSerializer.serialize(this.payload);
        String headerBase64 = Base64.encodeBase64URLSafeString(headerJson.getBytes(StandardCharsets.UTF_8));
        String payloadBase64 = Base64.encodeBase64URLSafeString(payloadJson.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = JWTAlgorithm.create(this.jwtAlgorithmType, entry.getSecretKey(), entry.getPrivateKey(), entry.getPublicKey()).sign(headerBase64.getBytes(StandardCharsets.UTF_8), payloadBase64.getBytes(StandardCharsets.UTF_8));
        String signatureBase64 = Base64.encodeBase64URLSafeString(signatureBytes);
        return String.format("%s.%s.%s", headerBase64, payloadBase64, signatureBase64);
    }

    public JWTBuilder setContext(RuntimeContext context) {
        this.context = context;
        return this;
    }

    public static void main(String[] args) {
        JWTBuilder.checkPrivatePublic(SSSecurityKeyAlgorithm.RSA);
        JWTBuilder.checkPrivatePublic(SSSecurityKeyAlgorithm.ES256);
        JWTBuilder.checkPrivatePublic(SSSecurityKeyAlgorithm.ES384);
        JWTBuilder.checkPrivatePublic(SSSecurityKeyAlgorithm.ES512);
        JWTBuilder.checkSecretKey(SSSecurityKeyAlgorithm.HS256);
        JWTBuilder.checkSecretKey(SSSecurityKeyAlgorithm.HS384);
        JWTBuilder.checkSecretKey(SSSecurityKeyAlgorithm.HS512);
    }

    private static void checkPrivatePublic(SSSecurityKeyAlgorithm algorithm) {
        SSSecurityKeyEntry entry = SSSecurityKeyGenerator.algorithm(algorithm).setPublic(true).generate();
        System.out.println("=========== " + algorithm.getName() + " ===============");
        System.out.println("Private Key");
        System.out.println(entry.getPrivateKey().getAlgorithm());
        System.out.println(entry.getPrivateKey().getFormat());
        System.out.println("Public Key");
        System.out.println(entry.getPublicKey().getAlgorithm());
        System.out.println(entry.getPublicKey().getFormat());
        byte[] privateKeyBytes = entry.getPrivateKey().getEncoded();
        byte[] publicKeyBytes = entry.getPublicKey().getEncoded();
        System.out.println(" ---- ");
        SSSecurityKeyEntry entry1 = SSSecurityKeyGenerator.algorithm(algorithm).createFrom(null, privateKeyBytes, publicKeyBytes);
        System.out.println("Private Key");
        System.out.println(entry1.getPrivateKey().getAlgorithm());
        System.out.println(entry1.getPrivateKey().getFormat());
        System.out.println("Public Key");
        System.out.println(entry1.getPublicKey().getAlgorithm());
        System.out.println(entry1.getPublicKey().getFormat());
        if (!entry.getPrivateKey().equals(entry1.getPrivateKey())) {
            throw new RuntimeException("Privtae keys not the same.");
        }
        if (!entry.getPublicKey().equals(entry1.getPublicKey())) {
            throw new RuntimeException("Public keys not the same.");
        }
        JWTBuilder.checkJWT(algorithm, entry);
    }

    private static void checkSecretKey(SSSecurityKeyAlgorithm algorithm) {
        SSSecurityKeyEntry entry = SSSecurityKeyGenerator.algorithm(algorithm).generate();
        System.out.println("=========== " + algorithm.getName() + " ===============");
        System.out.println("Secret Key");
        System.out.println(entry.getSecretKey().getAlgorithm());
        System.out.println(entry.getSecretKey().getFormat());
        System.out.println(com.streamscape.lib.utils.Base64.encodeBytes(entry.getSecretKey().getEncoded()));
        byte[] secredKeyBytes = entry.getSecretKey().getEncoded();
        System.out.println(" ---- ");
        SSSecurityKeyEntry entry1 = SSSecurityKeyGenerator.algorithm(algorithm).createFrom(secredKeyBytes, null, null);
        System.out.println("Secret Key");
        System.out.println(entry1.getSecretKey().getAlgorithm());
        System.out.println(entry1.getSecretKey().getFormat());
        System.out.println(com.streamscape.lib.utils.Base64.encodeBytes(entry1.getSecretKey().getEncoded()));
        if (!entry1.getSecretKey().equals(entry1.getSecretKey())) {
            throw new RuntimeException("Secret keys not the same.");
        }
        JWTBuilder.checkJWT(algorithm, entry);
    }

    private static void checkJWT(SSSecurityKeyAlgorithm algorithm, final SSSecurityKeyEntry entry) {
        SSSecurityKeyEntryProvider ssSecurityKeyEntryProvider = new SSSecurityKeyEntryProvider(){

            @Override
            public SSSecurityKeyEntry getEntryByName(String name) {
                if (Objects.equals(entry.getName(), name)) {
                    return entry;
                }
                return null;
            }

            @Override
            public SSSecurityKeyEntry getEntryByUUID(String uuid) {
                if (Objects.equals(entry.getUUID(), uuid)) {
                    return entry;
                }
                return null;
            }
        };
        for (JWTAlgorithmType jwtAlgotithmType : JWTBuilder.SSKeyAlgorithmToJWTAlg(algorithm)) {
            System.out.println(" ---- " + String.valueOf((Object)jwtAlgotithmType) + " --------");
            JWTAlgorithm jwtAlgorithm = JWTAlgorithm.create(jwtAlgotithmType, entry.getSecretKey(), entry.getPrivateKey(), entry.getPublicKey());
            String jwt = JWT.builder().setJwtAlgorithmType(jwtAlgotithmType).setSecurityKeyEntryProvider(ssSecurityKeyEntryProvider).setPayload(new JWTPayload().setIssuer("admin")).buildTokenInternal("admin", false);
            System.out.println(jwt);
            JWTDecodedToken decodedToken = JWT.decoder().setSSSecurityKeyEntryProvider(ssSecurityKeyEntryProvider).decodeAndVerify(jwt);
            System.out.println(decodedToken.getPayload().getIssuer());
        }
    }

    private static List<JWTAlgorithmType> SSKeyAlgorithmToJWTAlg(SSSecurityKeyAlgorithm algorithm) {
        return Arrays.stream(JWTAlgorithmType.values()).filter(a -> a.getSsKeyAlgorithm() == algorithm).collect(Collectors.toList());
    }
}

