/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jwt;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.jwt.JWT;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTDecodedToken;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTPayload;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenAuthenticatorService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JWTAuthenticatorServiceImpl
implements ApiKeyTokenAuthenticatorService {
    @Override
    public HTTPCredentials authenticate(String tokenId, String method, String uri, HttpServletRequest httpServletRequest) throws Authenticator.AuthenticationException {
        JWTDecodedToken decodedToken = null;
        try {
            decodedToken = JWT.decoder().setContext(RuntimeContext.getInstance()).decodeAndVerify(tokenId);
        }
        catch (Exception exception) {
            throw new Authenticator.AuthenticationFailedException(Utils.formatExceptionWithUnrepeatedCauses(exception), "8004");
        }
        JWTPayload payload = decodedToken.getPayload();
        if (payload.getExpiresAt() != null && payload.getExpiresAt() < System.currentTimeMillis() / 1000L) {
            throw new Authenticator.AuthenticationFailedException("Token has expired.", "8002");
        }
        if (payload.getNotBefore() != null && payload.getNotBefore() > System.currentTimeMillis() / 1000L) {
            throw new Authenticator.AuthenticationFailedException("Token is not valid yet.", "8003");
        }
        List<JWTPayload.JWTResource> resources = payload.getResources();
        if (resources == null || resources.size() == 0) {
            throw new Authenticator.AccessDeniedException("Access denied by token resouces list. It is empty.", "8006");
        }
        ApplicationResourceMatcher.Matcher matcher = ApplicationResourceMatcher.create(resources, (m, u) -> new JWTPayload.JWTResource(m, u));
        Application.ResourceBase resource = matcher.matches(method, uri);
        if (resource == null) {
            throw new Authenticator.AccessDeniedException("Access denied by token resources list.", "8006");
        }
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug(this, "Request {} {} matched to resource '{}'", method, uri, resource.toString());
        }
        HTTPCredentials credentials = new HTTPCredentials();
        credentials.setUserName(payload.getIssuer());
        credentials.setCredentials(payload.getIssuer());
        credentials.setDigestCalculator((userName, user, parameters) -> user.getName().toString());
        return credentials;
    }
}

