/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jaxrs;

import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.jaxrs.AuthorizedRequestFilterAnnotation;
import com.streamscape.sef.network.http.server.jaxrs.exception.HttpResourceError;
import com.streamscape.sef.network.http.server.jaxrs.injection.ServiceInject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/application")
@AuthorizedRequestFilterAnnotation
@Api(tags={"Application"}, produces="application/json,application/xml", consumes="application/json,application/xml")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@ApiResponses(value={@ApiResponse(code=400, message="Bad request", response=HttpResourceError.class), @ApiResponse(code=401, message="Unauthorized", response=HttpResourceError.class), @ApiResponse(code=405, message="Invalid arguments", response=HttpResourceError.class), @ApiResponse(code=406, message="Server error", response=HttpResourceError.class), @ApiResponse(code=500, message="Internal server error", response=HttpResourceError.class)})
public class ApplicationResource {
    @ServiceInject
    private ApplicationService applicationService;

    @POST
    @ApiOperation(value="Creates new application.")
    @ApiResponses(value={@ApiResponse(code=201, message="OK", response=Application.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@ApiParam(value="Application object that should be created", required=true) Application application, @Context HttpServletRequest httpRequest) {
        this.applicationService.create(application);
        return Response.status((int)201).entity((Object)application).build();
    }

    @PUT
    @ApiOperation(value="Updates existing application.")
    @ApiResponses(value={@ApiResponse(code=201, message="OK", response=Application.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response update(@ApiParam(value="Application object that should be updated", required=true) Application application) {
        this.applicationService.update(application);
        return Response.status((int)201).entity((Object)application).build();
    }

    @GET
    @Path(value="/{applicationId}")
    @ApiOperation(value="Gets application by specified ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Application.class), @ApiResponse(code=204, message="Application with specified ID not found")})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response get(@ApiParam(value="Application ID", required=true) @PathParam(value="applicationId") String applicationId, @ApiParam(value="Specifies either application resources should be loaded or not", required=false) @QueryParam(value="withResources") @DefaultValue(value="true") boolean withResources) {
        Application application = this.applicationService.get(applicationId, withResources);
        if (application != null) {
            return Response.ok((Object)application).build();
        }
        return Response.status((int)204).entity((Object)new HttpResourceError().setStatus(204).setMessage("Application doesn't exist.")).build();
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Gets all applications, that correspond specified criteria.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Application[].class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response getAll(@ApiParam(value="Application owner, null or empty means current user, * means any user", required=false) @QueryParam(value="owner") @DefaultValue(value="") String owner, @ApiParam(value="Application name, null, empty or * means any application name", required=false) @QueryParam(value="applicationName") @DefaultValue(value="") String applicationName, @ApiParam(value="Specifies either application resources should be loaded or not", required=false) @QueryParam(value="withResources") @DefaultValue(value="true") boolean withResources, @ApiParam(value="Specifies either system application should be returned as will or not", required=false) @QueryParam(value="withSystem") @DefaultValue(value="true") boolean withSystem) {
        return Response.ok(this.applicationService.getAll(owner, applicationName, withResources, withSystem)).build();
    }

    @DELETE
    @Path(value="/{applicationId}")
    @ApiOperation(value="Removes specified application with all dependent tokens.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=int.class), @ApiResponse(code=204, message="Application with specified ID doesn't exist")})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response delete(@ApiParam(value="Application ID", required=true) @PathParam(value="applicationId") String applicationId) {
        int count = this.applicationService.delete(applicationId);
        if (count != 0) {
            return Response.ok((Object)count).build();
        }
        return Response.status((int)204).entity((Object)new HttpResourceError().setStatus(204).setMessage("Application doesn't exist.")).build();
    }

    @DELETE
    @Path(value="/")
    @ApiOperation(value="Removes all applications with all dependent tokens that correspond specified criteria.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=int.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response deleteAll(@ApiParam(value="Application owner, null or empty means current user, * means any user", required=false) @QueryParam(value="owner") @DefaultValue(value="") String owner, @ApiParam(value="Application name, null, empty or * means any application name", required=false) @QueryParam(value="applicationName") @DefaultValue(value="") String applicationName) {
        return Response.ok((Object)this.applicationService.deleteAll(owner, applicationName)).build();
    }
}

