/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jaxrs;

import com.streamscape.Trace;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorInvalidArgumentsException;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationServiceImpl;
import com.streamscape.sef.network.http.server.jaxrs.AuthorizedRequestFilterAnnotation;
import com.streamscape.sef.network.http.server.jaxrs.GenericMessageBodyWriter;
import com.streamscape.sef.network.http.server.jaxrs.exception.HttpResourceError;
import com.streamscape.sef.network.http.server.jaxrs.injection.ServiceInject;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

@Path(value="/token")
@Api(tags={"API Key"}, produces="application/json,application/xml", consumes="application/json,application/xml")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@ApiResponses(value={@ApiResponse(code=400, message="Bad request", response=HttpResourceError.class), @ApiResponse(code=401, message="Unauthorized", response=HttpResourceError.class), @ApiResponse(code=405, message="Invalid arguments", response=HttpResourceError.class), @ApiResponse(code=406, message="Server error", response=HttpResourceError.class), @ApiResponse(code=500, message="Internal server error", response=HttpResourceError.class)})
public class ApiKeyTokenResource {
    @ServiceInject
    private ApiKeyTokenService apiKeyTokenService;
    @ServiceInject
    private ApplicationService applicationService;
    @ServiceInject
    private RuntimeAuthenticator authenticator;
    @Context
    private ExceptionMapper exceptionMapper;

    @GET
    @Path(value="/authorize/basic")
    @AuthorizedRequestFilterAnnotation
    @ApiOperation(value="Requests new token using default acceptor authorization.", notes="Requests new token based on default acceptor authentication. Either applicationId or applicationName should be specified.If name of the token not specified unique name will be generated based on template &ltapplicationName&gt_&ltusername&gt_timestamp.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ApiKeyToken.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response createBasicGet(@ApiParam(value="Application ID for token", required=false) @DefaultValue(value="") @QueryParam(value="applicationId") String applicationId, @ApiParam(value="Application name for token", required=false) @DefaultValue(value="") @QueryParam(value="applicationName") String applicationName, @ApiParam(value="Name of the token. If not set unique name will be generated.", required=false) @DefaultValue(value="") @QueryParam(value="name") String name, @ApiParam(value="Description of the token", required=false) @DefaultValue(value="") @QueryParam(value="description") String description, @ApiParam(value="Token owner.", required=false) @DefaultValue(value="") @QueryParam(value="owner") String owner, @ApiParam(value="Global or not", required=false) @DefaultValue(value="false") @QueryParam(value="global") Boolean global, @ApiParam(value="Expires in seconds, if not set or 0 then default configured in runtime will be used, -1 means never expired", required=false) @DefaultValue(value="0") @QueryParam(value="expiresIn") Integer expiresIn, @ApiParam(value="Extend period in seconds, if not set or 0 then default configured in runtime will be used, -1 means no extend", required=false) @DefaultValue(value="0") @QueryParam(value="extendPeriod") Integer extendPeriod, @ApiParam(value="Timeout in seconds, defines how long to wait to delete the token on master node after it was expired, -1 means no timeout, if not set or 0 then default configured in runtime will be used", required=false) @DefaultValue(value="0") @QueryParam(value="deleteTimeoutAfterExpiration") Integer deleteTimeoutAfterExpiration, @ApiParam(value="Security bindings.", required=false) @DefaultValue(value="") @FormParam(value="securityBindings") String securityBindings, @Context HttpServletRequest httpRequest) {
        ApiKeyToken apiKeyToken = this.createApiKeyToken(applicationId, applicationName, name, description, owner, global, expiresIn, extendPeriod, deleteTimeoutAfterExpiration, httpRequest, securityBindings);
        return Response.ok((Object)apiKeyToken).build();
    }

    @POST
    @Path(value="/authorize/native")
    @ApiOperation(value="Requests new token using provided username and password.", notes="Requests new token based on provided username and password. Either applicationId or applicationName should be specified.If name of the token not specified unique name will be generated based on template &ltapplicationName&gt_&ltusername&gt_timestamp.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ApiKeyToken.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    public Response createNativePost(@ApiParam(value="User name", required=true) @FormParam(value="username") String username, @ApiParam(value="User password", required=true) @FormParam(value="password") String password, @ApiParam(value="Application ID for token", required=false) @DefaultValue(value="") @FormParam(value="applicationId") String applicationId, @ApiParam(value="Application name for token", required=false) @DefaultValue(value="") @FormParam(value="applicationName") String applicationName, @ApiParam(value="Name of the token. If not set unique name will be generated.", required=false) @DefaultValue(value="") @FormParam(value="name") String name, @ApiParam(value="Description of the token", required=false) @DefaultValue(value="") @FormParam(value="description") String description, @ApiParam(value="Token owner.", required=false) @DefaultValue(value="") @QueryParam(value="owner") String owner, @ApiParam(value="Global or not", required=false) @DefaultValue(value="false") @FormParam(value="global") Boolean global, @ApiParam(value="Expires in seconds, if not set or 0 then default configured in runtime will be used, -1 means never expired", required=false) @DefaultValue(value="0") @QueryParam(value="expiresIn") Integer expiresIn, @ApiParam(value="Extend period in seconds, if not set or 0 then default configured in runtime will be used, -1 means no extend", required=false) @DefaultValue(value="0") @QueryParam(value="extendPeriod") Integer extendPeriod, @ApiParam(value="Timeout in seconds, defines how long to wait to delete the token on master node after it was expired, -1 means no timeout, if not set or 0 then default configured in runtime will be used", required=false) @DefaultValue(value="-1") @QueryParam(value="deleteTimeoutAfterExpiration") Integer deleteTimeoutAfterExpiration, @ApiParam(value="Security bindings.", required=false) @DefaultValue(value="") @FormParam(value="securityBindings") String securityBindings, @ApiParam(value="", required=false) @DefaultValue(value="") @FormParam(value="redirectUri") String redirectUri, @ApiParam(value="", required=false) @DefaultValue(value="") @FormParam(value="errorRedirectUri") String errorRedirectUri, @ApiParam(value="", required=false) @DefaultValue(value="") @FormParam(value="basePath") String basePath, @ApiParam(value="Response token place. JSON - in the response body. COOKIE - in response cookie. ", required=false) @DefaultValue(value="JSON") @FormParam(value="responseFormat") TokenResponseFormat responseFormat, @Context HttpServletRequest httpRequest, @Context RuntimeContext runtimeContext) {
        URI redirectUriParsed = null;
        URI errorRedirectUriParsed = null;
        try {
            Application application;
            try {
                if (redirectUri != null && redirectUri.length() > 0) {
                    redirectUriParsed = new URI(redirectUri);
                }
            }
            catch (URISyntaxException e) {
                throw new ApiKeyErrorInvalidArgumentsException("Invalid redirectUri specified.");
            }
            try {
                if (errorRedirectUri != null && errorRedirectUri.length() > 0) {
                    errorRedirectUriParsed = new URI(errorRedirectUri);
                }
            }
            catch (URISyntaxException e) {
                throw new ApiKeyErrorInvalidArgumentsException("Invalid errorRedirectUri specified.");
            }
            try {
                HTTPCredentials credentials = HTTPCredentials.buildDigest(username, password);
                this.authenticator.authenticate(credentials);
                AbstractAuthenticator.setCredentialsToRequest(httpRequest, credentials);
                HTTPAuthenticationManager manager = runtimeContext.getHTTPAuthenticationManager();
                manager.authorize(credentials);
                this.applicationService = manager.getApiKeyServiceFactory().getApplicationService();
                this.apiKeyTokenService = manager.getApiKeyServiceFactory().getApiKeyTokenService();
            }
            catch (Authenticator.AuthenticationFailedException exception) {
                throw new ForbiddenException(exception.getMessage(), exception.getCause());
            }
            ApiKeyToken apiKeyToken = this.createApiKeyToken(applicationId, applicationName, name, description, owner, global, expiresIn, extendPeriod, deleteTimeoutAfterExpiration, httpRequest, securityBindings);
            if (basePath != null && basePath.length() > 0 && (application = this.applicationService.get(apiKeyToken.getApplicationId(), true)) != null && application.matches(null, basePath) == null) {
                this.apiKeyTokenService.revoke(apiKeyToken.getTokenId());
                throw new ForbiddenException("Application '" + application.getName() + "' doesn't allow access to path '" + basePath + "'.");
            }
            if (responseFormat == TokenResponseFormat.COOKIE) {
                Response.ResponseBuilder builder = null;
                builder = redirectUriParsed != null ? Response.temporaryRedirect((URI)redirectUriParsed) : Response.ok();
                int maxAge = -1;
                if (apiKeyToken.getExpiresIn() > 0 && apiKeyToken.getExtendPeriod() <= 0) {
                    maxAge = apiKeyToken.getExpiresIn() + 60;
                }
                return builder.cookie(new NewCookie[]{new NewCookie("x-session-token", apiKeyToken.getTokenId(), basePath, null, null, maxAge, false, true)}).build();
            }
            if (redirectUriParsed != null) {
                String redirectUriWithQuery = redirectUri + "?token=" + HTTPUtils.encodeString(this.serializeUsingDefaultJsonSerializer(runtimeContext, apiKeyToken));
                try {
                    redirectUriParsed = new URI(redirectUriWithQuery);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return Response.temporaryRedirect((URI)redirectUriParsed).build();
            }
            return Response.ok((Object)apiKeyToken).build();
        }
        catch (Exception exception) {
            if (errorRedirectUriParsed != null) {
                String errorRedirectUriWithQuery = errorRedirectUri + (errorRedirectUri.indexOf(63) > 0 ? "&" : "?") + "error=" + HTTPUtils.encodeString(this.serializeUsingDefaultJsonSerializer(runtimeContext, this.exceptionMapper.toResponse((Throwable)exception).getEntity()));
                try {
                    errorRedirectUriParsed = new URI(errorRedirectUriWithQuery);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return Response.temporaryRedirect((URI)errorRedirectUriParsed).build();
            }
            throw exception;
        }
    }

    private Set<ApiKeySecurityBinding> parseSecurityBindings(String securityBindings) {
        if (securityBindings != null && securityBindings.trim().length() > 0) {
            try {
                return Arrays.asList(securityBindings.split(",")).stream().map(e -> ApiKeySecurityBinding.valueOf(e.toUpperCase())).collect(Collectors.toSet());
            }
            catch (Exception exception) {
                throw new ApiKeyErrorInvalidArgumentsException("Invalid securityBindings specified.");
            }
        }
        return null;
    }

    private ApiKeyToken createApiKeyToken(String applicationId, String applicationName, String name, String description, String owner, Boolean global, Integer expiresIn, Integer extendPeriod, Integer deleteTimeoutAfterExpiration, HttpServletRequest httpRequest, String securityBindingsString) {
        Set<ApiKeySecurityBinding> securityBindings = this.parseSecurityBindings(securityBindingsString);
        if (!(applicationId != null && applicationId.length() != 0 || applicationName != null && applicationName.length() != 0)) {
            throw new BadRequestException("Either query parameter 'applicationId' or 'applicationName' should be specified.");
        }
        Application application = null;
        if (applicationId == null || applicationId.length() == 0) {
            List<Application> applications = this.applicationService.getAll("*", applicationName, false, true);
            if (applications.size() == 0) {
                throw new BadRequestException("Application with name '" + applicationName + "' not found.");
            }
            if (applications.size() > 1) {
                throw new BadRequestException("There is more than one application with name '" + applicationName + "'. Please specify applicationId.");
            }
            application = applications.get(0);
            applicationId = application.getApplicationId();
        }
        if (name == null || ((String)name).length() == 0) {
            if (applicationName == null) {
                if (application == null && (application = this.applicationService.get(applicationId, false)) == null) {
                    throw new BadRequestException("Application with specified id '" + applicationId + "' doesn't exist.");
                }
                applicationName = application.getName();
            }
            name = applicationName + "_" + httpRequest.getUserPrincipal().getName() + "_" + System.currentTimeMillis();
        }
        if (application == null && (application = this.applicationService.get(applicationId, false)) == null) {
            throw new BadRequestException("Application with specified id '" + applicationId + "' doesn't exist.");
        }
        securityBindings = this.negotiateSecurityBindings(application, securityBindings);
        ApplicationServiceImpl.checkSecurityBindings(securityBindings);
        HashMap<ApiKeySecurityBinding, String> bindingsMap = new HashMap<ApiKeySecurityBinding, String>();
        if (securityBindings != null && securityBindings.size() > 0) {
            if (securityBindings.contains((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION)) {
                bindingsMap.put(ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION, httpRequest.getSession(true).getId());
            }
            if (securityBindings.contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION)) {
                bindingsMap.put(ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION, httpRequest.getHeader("User-Agent"));
            }
        }
        ApiKeyToken apiKeyToken = new ApiKeyToken();
        apiKeyToken.setName((String)name);
        apiKeyToken.setDescription(description);
        apiKeyToken.setGlobal(global);
        apiKeyToken.setApplicationId(applicationId);
        if (expiresIn != null) {
            apiKeyToken.setExpiresIn(expiresIn);
        } else {
            apiKeyToken.setExpiresIn(-1);
        }
        if (extendPeriod != null) {
            apiKeyToken.setExtendPeriod(extendPeriod);
        } else {
            apiKeyToken.setExtendPeriod(-1);
        }
        if (deleteTimeoutAfterExpiration != null) {
            apiKeyToken.setDeleteTimeoutAfterExpiration(deleteTimeoutAfterExpiration);
        } else {
            apiKeyToken.setDeleteTimeoutAfterExpiration(0);
        }
        if (owner != null && owner.length() > 0) {
            apiKeyToken.setOwner(owner);
        }
        apiKeyToken.setSecurityBindingsValues(bindingsMap);
        apiKeyToken.setSecurityBindings(securityBindings);
        this.apiKeyTokenService.create(apiKeyToken);
        return apiKeyToken;
    }

    private String serializeUsingDefaultJsonSerializer(RuntimeContext runtimeContext, Object object) {
        try {
            return GenericMessageBodyWriter.getDefault(runtimeContext).getJsonSerializer().serialize(object);
        }
        catch (SerializerException exception) {
            Trace.logException(this, exception, true);
            return exception.toString();
        }
    }

    private Set<ApiKeySecurityBinding> negotiateSecurityBindings(Application application, Set<ApiKeySecurityBinding> securityBindings) {
        if (application.getSecurityBindings() != null) {
            if (securityBindings != null) {
                if (application.getSecurityBindings().contains((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION)) {
                    if (securityBindings.contains((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE)) {
                        throw new ApiKeyErrorInvalidArgumentsException("If application defines " + String.valueOf((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION) + " security binding token cannot override it with " + String.valueOf((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE) + ".");
                    }
                    securityBindings.add(ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION);
                }
                if (application.getSecurityBindings().contains((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE) && !securityBindings.contains((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION)) {
                    securityBindings.add(ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE);
                }
                if (application.getSecurityBindings().contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION)) {
                    if (securityBindings.contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE)) {
                        throw new ApiKeyErrorInvalidArgumentsException("If application defines " + String.valueOf((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION) + " security binding token cannot override it with " + String.valueOf((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE) + ".");
                    }
                    securityBindings.add(ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION);
                }
                if (application.getSecurityBindings().contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE) && !securityBindings.contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION)) {
                    securityBindings.add(ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE);
                }
            } else {
                securityBindings = application.getSecurityBindings();
            }
        }
        return securityBindings;
    }

    @GET
    @Path(value="/{token}")
    @AuthorizedRequestFilterAnnotation
    @ApiOperation(value="Gets API key token info.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ApiKeyToken.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response get(@ApiParam(value="API key token", required=true) @PathParam(value="token") String token) {
        ApiKeyToken apiKeyToken = this.apiKeyTokenService.get(token);
        if (apiKeyToken != null) {
            return Response.ok((Object)apiKeyToken).build();
        }
        return Response.status((int)204).entity((Object)new HttpResourceError().setStatus(204).setMessage("API key doesn't exist.")).build();
    }

    @GET
    @Path(value="/")
    @AuthorizedRequestFilterAnnotation
    @ApiOperation(value="Gets API keys that corresponds specified criteria.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ApiKeyToken[].class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response getAll(@ApiParam(value="API Key owner user, null or empty means current user, * means any user", required=false) @QueryParam(value="owner") @DefaultValue(value="") String owner, @ApiParam(value="API Key name, null, empty or * means any name", required=false) @QueryParam(value="tokenName") @DefaultValue(value="") String tokenName, @ApiParam(value="Application name, null, empty or * means any application ID", required=false) @QueryParam(value="applicationId") @DefaultValue(value="") String applicationId) {
        return Response.ok(this.apiKeyTokenService.getAll(owner, tokenName, applicationId)).build();
    }

    @DELETE
    @Path(value="/{token}")
    @AuthorizedRequestFilterAnnotation
    @ApiOperation(value="Revokes API token.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=void.class), @ApiResponse(code=204, message="API Key token with specified ID doesn't exist", response=HttpResourceError.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response delete(@ApiParam(value="API key token", required=true) @PathParam(value="token") String token) {
        int count = this.apiKeyTokenService.revoke(token);
        if (count != 0) {
            return Response.ok((Object)count).build();
        }
        return Response.status((int)204).entity((Object)new HttpResourceError().setStatus(204).setMessage("API Key token doesn't exist.")).build();
    }

    @DELETE
    @Path(value="/")
    @AuthorizedRequestFilterAnnotation
    @ApiOperation(value="Revokes all tokens that correspons specified criteria.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=int.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public Response revokeAll(@ApiParam(value="API Key owner user, null or empty means current user, * means any user", required=false) @QueryParam(value="owner") @DefaultValue(value="") String owner, @ApiParam(value="API Key name, null, empty or * means any name", required=false) @QueryParam(value="tokenName") @DefaultValue(value="") String tokenName) {
        return Response.ok((Object)this.apiKeyTokenService.revokeAll(owner, tokenName)).build();
    }

    @POST
    @Path(value="/revoke")
    @ApiOperation(value="Revokes API token that set in cookies.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=void.class), @ApiResponse(code=204, message="API Key token with specified ID doesn't exist", response=HttpResourceError.class)})
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    public Response revoke(@ApiParam(value="", required=false) @DefaultValue(value="") @FormParam(value="basePath") String basePath, @ApiParam(value="", required=false) @DefaultValue(value="") @FormParam(value="redirectUri") String redirectUri, @Context HttpServletRequest httpRequest, @Context RuntimeContext runtimeContext) {
        URI redirectUriParsed = null;
        try {
            if (redirectUri != null && redirectUri.length() > 0) {
                redirectUriParsed = new URI(redirectUri);
            }
        }
        catch (URISyntaxException e) {
            throw new ApiKeyErrorInvalidArgumentsException("Invalid redirectUri specified.");
        }
        if (redirectUriParsed != null) {
            Response.ResponseBuilder builder = null;
            builder = redirectUriParsed != null ? Response.temporaryRedirect((URI)redirectUriParsed) : Response.ok();
            String token = XSessionAuthenticator.getToken(httpRequest);
            if (this.apiKeyTokenService != null) {
                int count;
                if (token != null && token.length() > 0 && (count = this.apiKeyTokenService.revoke(token)) == 0) {
                    Trace.logInfo(this, "Token revoke: token " + ApiKeyToken.trim(token) + " doesn't exist.");
                }
            } else {
                Trace.logInfo(this, "Request is not authorized, it seems that token doesn't exist, just remove it fro cookies.");
            }
            return builder.cookie(new NewCookie[]{new NewCookie("x-session-token", "", basePath, null, null, 0, false, true)}).build();
        }
        return null;
    }

    public static enum TokenResponseFormat {
        JSON,
        COOKIE;

    }
}

