/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jaxrs;

import com.streamscape.sef.network.http.server.authentication.jaxrs.ApiKeyTokenResource;
import com.streamscape.sef.network.http.server.authentication.jaxrs.ApplicationResource;
import com.streamscape.sef.network.http.server.jaxrs.swagger.AbstractSwaggerJaxrsBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ApiKeySwaggerJaxrsBuilder
extends AbstractSwaggerJaxrsBuilder {
    @Override
    protected Set<Class<?>> getClasses() {
        return new HashSet(Arrays.asList(ApiKeyTokenResource.class, ApplicationResource.class));
    }

    @Override
    protected String getTitle() {
        return "StreamScape API Key and Applications";
    }

    @Override
    protected String getDescription() {
        return "StreamScape REST API for API Key authentication and applications management.<br><br>\nAPI Key application can be created by any user and defines set of resources that can be accessed by the client authorized in this application.<br>\nApplication resource is a collection of pairs (HTTP method mask, URL mask).<br><br>\nHTTP method mask format: {asterisk or <method>[|<method>...]}. HTTP method mask examples:\n<table>\n<tr><td>asterisk</td><td>any HTTP method</td></tr>\n<tr><td>POST</td><td>only POST HTTP method</td></tr>\n<tr><td>GET|POST</td><td>only POST or GET HTTP methods</td></tr>\n</table><br>\nURL mask has format like JAX-RS path templates. Common URL mask format: /segment1/segment2/....[/asterisk].<br>\nAllowed values for segments:\n<table>\n<tr><td>mysegment</td><td>means segment with value 'mysegment'</td></tr>\n<tr><td>{somename}</td><td>means any segment</td></tr>\n<tr><td>{somename:regular expression}</td><td>means any segment that matches specified regular expression</td></tr>\n<tr><td>asterisk at the end</td><td>means any segments at the end</td></tr>\n</table><br>\nURL mask examples:\n<table>\n<tr><td>/department/employees</td><td>one URL /department/employees</td></tr>\n<tr><td>/department/employees/asterisk</td><td>any URL that starts with /department/employees/</td></tr>\n<tr><td>/department/{myanysegment}/projects</td><td>any URL that starts with /department, any second segment and third segment is projects</td></tr>\n<tr><td>/department/{c:\\dasterisk}/projects</td><td>any URL that starts with /department, second segment contains only digits and third segment is projects</td></tr>\n</table><br>\nTo get authorized in application client should create API Key token.<br>API Key token is bound to single application and has expiration timeout.<br>\nToken allows any client to get access to bound application's resources with permission of the user that issued the token.<br>\nTo use the token user should add header or query parameter x-session-token with value of the token to HTTP requests.<br>\nUnsuccessfull authentication responses:\n<table>\n<tr><td>Token place</td><td>Not Authorized(token is missing) or Authentication Failed(token is invalid or expired)</td><td>Access To Resource Denied</td></tr><tr><td>header</td><td>Status 401<br>hedaer WWW-Authenticate=x-session-token error=\"error description\"</td><td>Status 403<br>Content: {status:403, message:\"error description\"}</td></tr><tr><td>query</td><td>Status 406<br>Content: {status:401, message:\"error description\"}</td><td>Status 403<br>Content: {status:403, message:\"error description\"}</td></tr></table><br>\n";
    }

    @Override
    protected String getBasePath() {
        return "/security/apikey";
    }
}

