/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.jaxrs;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.Service;
import com.streamscape.sef.network.http.server.jaxrs.injection.AbstractServiceInjectionResolver;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class ApiKeyServiceInjectionResolver
extends AbstractServiceInjectionResolver {
    private static final Set<Class<?>> types = new HashSet<Class>(Arrays.asList(ApplicationService.class, ApiKeyTokenService.class));

    @Override
    public Set<Class<?>> getInjectedTypes() {
        return new HashSet(types);
    }

    @Override
    public <T> T resolve(Class<T> type, InjectionContext context) {
        Service<ApplicationDao> result = null;
        if (type == ApplicationService.class || type == ApiKeyTokenService.class) {
            HttpServletRequest request = this.resolve(Context.class, HttpServletRequest.class, context);
            HTTPAuthenticationManager manager = context.get(RuntimeContext.class).getHTTPAuthenticationManager();
            HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
            if (credentials != null) {
                manager.authorize(credentials);
                if (type == ApplicationService.class) {
                    result = manager.getApiKeyServiceFactory().getApplicationService();
                } else if (type == ApiKeyTokenService.class) {
                    result = manager.getApiKeyServiceFactory().getApiKeyTokenService();
                }
            }
        }
        return (T)result;
    }
}

