/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate.servlet;

import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.AbstractDelegateServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DelegateAuthorizeServlet
extends AbstractDelegateServlet {
    @Override
    public void onProcessRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, DelegateAuthenticationException {
        String callback = req.getParameter("callback");
        if (callback == null || callback.length() == 0) {
            throw new DelegateAuthenticationException("invalid_request", "Parameter 'callback' is missing.");
        }
        String providerName = req.getParameter("provider");
        if (providerName == null) {
            throw new DelegateAuthenticationException("invalid_request", "Parameter 'provider' is missing.", null, callback);
        }
        DelegateAuthenticationProvider provider = this.getProviderManager().getProvider(providerName);
        if (provider == null) {
            throw new DelegateAuthenticationException("invalid_request", "Specified provider '" + providerName + "' not found.", null, callback);
        }
        String trackingResponse = req.getParameter("trackingResponse");
        if (trackingResponse != null && trackingResponse.equalsIgnoreCase("no")) {
            throw new DelegateAuthenticationException("access_denied", "User declined profile tracking request.", null, callback);
        }
        if (provider.getConfiguration().getProfileTracking() && trackingResponse == null) {
            this.redirectToTrackingPage(callback, providerName, res);
        } else {
            res.sendRedirect(provider.getAuthenticationUrl() + provider.getRequestCodeQuery(callback));
        }
    }

    private void redirectToTrackingPage(String callback, String providerName, HttpServletResponse res) throws IOException {
        ServletOutputStream answer = res.getOutputStream();
        answer.println("<html>");
        answer.println("<head><title>StreamScape profile tracking page</title></head>");
        answer.println("<body>");
        answer.println("<h3>Are you agree with profile tracking?</h3>");
        answer.println("<form id=\"loginform\" action=\"/security/delegate/authorize\" method=\"post\">");
        answer.println("<input type=\"radio\" name=\"trackingResponse\" value=\"yes\"> Yes<Br>");
        answer.println("<input type=\"radio\" name=\"trackingResponse\" value=\"no\"> No<Br>");
        this.addHiddenField("callback", callback, answer);
        this.addHiddenField("provider", providerName, answer);
        answer.println("<input type=\"submit\" name=\"submit\" id=\"submit\"/>");
        answer.println("</form>");
        answer.println("</body>");
        answer.println("</html>");
        answer.close();
    }

    protected void addHiddenField(String name, String value, ServletOutputStream answer) throws IOException {
        if (value == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"hidden\" id=\"").append(name).append("\" name=\"").append(name).append("\"");
        builder.append(" value=\"").append(value).append("\"/>");
        answer.println(builder.toString());
    }
}

