/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate.servlet;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.vcard.Photo;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.delegate.CodeInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationResponse;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.AbstractDelegateServlet;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DelegateAuthorizeCallbackServlet
extends AbstractDelegateServlet {
    private static Object runtimeMutex = new Object();

    @Override
    public void onProcessRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, DelegateAuthenticationException {
        String callback = req.getParameter("state");
        String providerName = req.getRequestURI().substring(req.getRequestURI().lastIndexOf("/") + 1);
        DelegateAuthenticationProvider provider = this.getProviderManager().getProvider(providerName);
        if (provider == null) {
            throw new DelegateAuthenticationException("invalid_request", "Specified provider '" + providerName + "' not found.", null, callback);
        }
        try {
            CodeInfo codeResponse = provider.parseCodeReply(req.getQueryString());
            URL url = new URL(provider.getTokenUrl());
            NVPair[] data = provider.getRequestTokenPostData(codeResponse.getCode());
            HTTPClient httpClient = new HTTPClient(url);
            HTTPClientResponse response = httpClient.Post(url.getPath(), data);
            if (response == null) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Token request failed");
            }
            if (response.getData() == null) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Token request returns no data, status code: " + response.getStatusCode());
            }
            DelegateTokenInfo tokenInfo = provider.parseTokenReply(response.getData());
            tokenInfo.setExpiresIn((long)this.getProviderManager().getConfiguration().getSessionTimeout() * 60L);
            tokenInfo.setTokenType("Delegate");
            UserInfo userInfo = provider.getUserInfo(tokenInfo);
            HTTPCredentials credentials = this.getRuntimeUser(userInfo, provider);
            this.getProviderManager().createContext(tokenInfo, userInfo, provider, credentials);
            DelegateAuthenticationResponse.build(tokenInfo, callback).reply(res);
        }
        catch (DelegateAuthenticationException exception) {
            exception.setRedirectUri(callback);
            throw exception;
        }
        catch (ModuleException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to perform token request: " + exception.toString(), null, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPCredentials getRuntimeUser(UserInfo userInfo, DelegateAuthenticationProvider provider) throws DelegateAuthenticationException {
        try {
            SecurityManager manager = RuntimeContext.getInstance().getSecurityManager();
            if (!manager.existsGroup(provider.getConfiguration().getUsersGroup())) {
                throw new DelegateAuthenticationException("access_denied", "Provider users group '" + provider.getConfiguration().getUsersGroup() + "' doesn't exists.");
            }
            String runtimeUserName = userInfo.getUsername() + ":" + provider.getConfiguration().getName().toLowerCase();
            User user = manager.lookupUser(runtimeUserName);
            if (user != null && !user.isMemberOf(provider.getConfiguration().getUsersGroup())) {
                Object object = runtimeMutex;
                synchronized (object) {
                    if (!user.isMemberOf(provider.getConfiguration().getUsersGroup())) {
                        String newRuntimeUserName;
                        int i = 0;
                        while ((user = manager.lookupUser(newRuntimeUserName = runtimeUserName + ":" + i++)) != null && !user.isMemberOf(provider.getConfiguration().getUsersGroup())) {
                        }
                        runtimeUserName = newRuntimeUserName;
                        if (user == null) {
                            this.createRuntimeUser(manager, runtimeUserName, provider);
                        }
                    }
                }
            } else if (user == null) {
                this.createRuntimeUser(manager, runtimeUserName, provider);
            }
            HTTPCredentials credentials = HTTPCredentials.buildDigest(runtimeUserName, manager.resetPassword(runtimeUserName));
            userInfo.setRuntimeUsername(runtimeUserName);
            if (provider.getConfiguration().isStoreProfile()) {
                vCard vcard = manager.getVCard(runtimeUserName);
                boolean firstTime = false;
                if (vcard == null) {
                    vcard = new vCard();
                    firstTime = true;
                }
                vcard.setHomeEMail(userInfo.getEmail());
                vcard.setNickName(userInfo.getUsername());
                vcard.setFullName(userInfo.getFullname());
                vcard.setURL(userInfo.getProfileLink());
                vcard.setGender(userInfo.getGender());
                if ((!vcard.hasPhoto() || firstTime) && userInfo.getPictureLink() != null && userInfo.getPictureLink().length() > 0) {
                    try {
                        URL url = new URL(userInfo.getPictureLink());
                        HTTPClient httpClient = new HTTPClient(url);
                        HTTPClientResponse response = httpClient.Get(url.getPath());
                        if (response == null || response.getStatusCode() != 200) {
                            throw new Exception("Response is null or status code is not OK");
                        }
                        if (response.getData() == null) {
                            throw new Exception("Response doesn't contain data");
                        }
                        vcard.setPhoto(new Photo(response.getHeader("Content-Type"), new Base64Encoder().encode(response.getData())));
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to get picture for user '" + userInfo.getUsername() + "', error:  " + exception.getMessage());
                    }
                }
                try {
                    manager.setVCard(runtimeUserName, vcard);
                }
                catch (SecurityManagerException exception) {
                    Trace.logError(this, "Failed to save vcard for user '" + userInfo.getUsername() + "', error:  " + exception.toString());
                }
            }
            return credentials;
        }
        catch (SecurityManagerException exception) {
            throw new DelegateAuthenticationException("access_denied", "Security manager exception: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRuntimeUser(SecurityManager manager, String username, DelegateAuthenticationProvider provider) throws SecurityManagerException {
        Object object = runtimeMutex;
        synchronized (object) {
            manager.createUser(username, null, "Automatically created user for delegate authentication provider '" + provider.getConfiguration().getName() + "'.");
            manager.addUserToGroup(username, provider.getConfiguration().getUsersGroup());
        }
    }
}

