/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.FacebookDelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.GoogleDelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthErrorResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthTokenResponse;

public class Utils {
    private static JSONSerializer serializer = null;

    public static JSONSerializer getJSONSerializer() throws DelegateAuthenticationException {
        if (serializer == null) {
            Utils.initJSONSerializer();
        }
        return serializer;
    }

    private static synchronized void initJSONSerializer() throws DelegateAuthenticationException {
        try {
            if (serializer != null) {
                return;
            }
            ObjectMediationAliasManager aliasManager = new ObjectMediationAliasManager();
            aliasManager.alias("OAuthErrorResponseObject", OAuthErrorResponse.ResponseObject.class);
            aliasManager.alias("OAuthTokenResponseObject", OAuthTokenResponse.ResponseObject.class);
            aliasManager.alias("GoogleUserInfo", GoogleDelegateAuthenticationProvider.GoogleUserInfo.class);
            aliasManager.alias("FacebookUserInfo", FacebookDelegateAuthenticationProvider.FacebookUserInfo.class);
            aliasManager.alias("UserInfo", UserInfo.class);
            serializer = JSONSerializerFactory.getInstance().createSerializerDefaultBuilderLazy("JSONSerializer$DelegateAuthentication").apply(builder -> {
                builder.setAliasManager(aliasManager);
                builder.setJsonNotation(JsonNotation.TYPE);
                builder.setJsonNotationLevel(JsonNotationLevel.POLYMORPHIC_OBJECTS);
                builder.setPrettyPrint(true);
                builder.setSkipNulls(true);
            }).getOrBuild();
        }
        catch (FactoryManagerException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to initialize JSON serializer: " + exception.toString());
        }
    }
}

