/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.ProtocolNotSuppException;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.authentication.delegate.AbstractDelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class GoogleDelegateAuthenticationProvider
extends AbstractDelegateAuthenticationProvider {
    public static final String GET_USER_INFO_URL = "https://www.googleapis.com/oauth2/v1/userinfo";
    public static final String AUTHENTICATION_URL = "https://accounts.google.com/o/oauth2/auth";
    public static final String TOKEN_URL = "https://accounts.google.com/o/oauth2/token";
    public static final String REVOKE_URL = "https://accounts.google.com/o/oauth2/revoke";
    public static final String USER_INFO_PROFILE_SCOPE = "https://www.googleapis.com/auth/userinfo.profile";

    @Override
    public String getAuthenticationUrl() {
        return AUTHENTICATION_URL;
    }

    @Override
    public String getTokenUrl() {
        return TOKEN_URL;
    }

    @Override
    public String getRevokeUrl() {
        return REVOKE_URL;
    }

    @Override
    protected String onGetRequestCodeQuery(String url) {
        return url + "&approval_prompt=force";
    }

    @Override
    protected String onGetScopes() {
        String scopes = this.configuration.getScopesSpaceDelimited();
        if (scopes == null || scopes.trim().length() == 0) {
            return USER_INFO_PROFILE_SCOPE;
        }
        return scopes + " https://www.googleapis.com/auth/userinfo.profile";
    }

    @Override
    public void validateToken(DelegateTokenInfo token) throws DelegateAuthenticationException {
    }

    @Override
    public UserInfo getUserInfo(DelegateTokenInfo token) throws DelegateAuthenticationException {
        try {
            URL url = new URL(GET_USER_INFO_URL);
            HTTPClient httpClient = new HTTPClient(url);
            HTTPClientResponse response = httpClient.Get(url.getPath() + "?access_token=" + token.getAccessToken());
            if (response == null || response.getStatusCode() != 200) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request failed, status code: " + String.valueOf(response != null ? Integer.valueOf(response.getStatusCode()) : "null"));
            }
            if (response.getData() == null) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request returns no data");
            }
            Trace.logDebug(this, "Google user info response: " + new String(response.getData()));
            Object object = Utils.getJSONSerializer().deserialize("GoogleUserInfo", response.getData());
            if (object == null || !(object instanceof GoogleUserInfo)) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Wrong response from google server: " + new String(response.getData()));
            }
            GoogleUserInfo googleUserInfo = (GoogleUserInfo)object;
            UserInfo userInfo = new UserInfo();
            userInfo.setId(googleUserInfo.id);
            userInfo.setUsername(googleUserInfo.id);
            userInfo.setEmail(googleUserInfo.email);
            userInfo.setFullname(googleUserInfo.name);
            userInfo.setFirstName(googleUserInfo.given_name);
            userInfo.setLastName(googleUserInfo.family_name);
            userInfo.setProfileLink(googleUserInfo.link);
            userInfo.setPictureLink(googleUserInfo.picture);
            userInfo.setLocale(googleUserInfo.locale);
            userInfo.setGender(googleUserInfo.gender);
            if (userInfo.getEmail() != null) {
                userInfo.setUsername(userInfo.getEmail().substring(0, userInfo.getEmail().indexOf("@")));
            }
            return userInfo;
        }
        catch (MalformedURLException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to parse get user info url: " + exception.toString());
        }
        catch (ProtocolNotSuppException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to parse get user info url: " + exception.toString());
        }
        catch (IOException exception) {
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request failed: " + exception.toString());
        }
        catch (ModuleException exception) {
            throw new DelegateAuthenticationException("internal_error", "Get user info request failed: " + exception.toString());
        }
        catch (SerializerException exception) {
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to desserialize google response on get user info request, cause: " + exception.toString());
        }
    }

    @Override
    protected String getAccessTokenPrefix() {
        return "GGL";
    }

    public static class GoogleUserInfo {
        public String id;
        public String email;
        public String verified_email;
        public String name;
        public String given_name;
        public String family_name;
        public String link;
        public String picture;
        public String gender;
        public String locale;
    }
}

