/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.ProtocolNotSuppException;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.authentication.delegate.AbstractDelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.Utils;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class FacebookDelegateAuthenticationProvider
extends AbstractDelegateAuthenticationProvider {
    public static final String GET_USER_INFO_URL = "https://graph.facebook.com/me";
    public static final String AUTHENTICATION_URL = "https://www.facebook.com/dialog/oauth";
    public static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";

    @Override
    public String getAuthenticationUrl() {
        return AUTHENTICATION_URL;
    }

    @Override
    public String getTokenUrl() {
        return TOKEN_URL;
    }

    @Override
    public String getRevokeUrl() {
        return null;
    }

    @Override
    public void validateToken(DelegateTokenInfo token) throws DelegateAuthenticationException {
    }

    @Override
    public UserInfo getUserInfo(DelegateTokenInfo token) throws DelegateAuthenticationException {
        try {
            URL url = new URL(GET_USER_INFO_URL);
            HTTPClient httpClient = new HTTPClient(url);
            HTTPClientResponse response = httpClient.Get(url.getPath() + "?access_token=" + token.getAccessToken());
            if (response == null || response.getStatusCode() != 200) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request failed, status code: " + String.valueOf(response != null ? Integer.valueOf(response.getStatusCode()) : "null"));
            }
            if (response.getData() == null) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request returns no data");
            }
            Trace.logDebug(this, "Facebook user info response: " + new String(response.getData()));
            Object object = Utils.getJSONSerializer().deserialize("FacebookUserInfo", response.getData());
            if (object == null || !(object instanceof FacebookUserInfo)) {
                throw new DelegateAuthenticationException("invalid_auth_server_response", "Wrong response from google server: " + new String(response.getData()));
            }
            FacebookUserInfo facebookUserInfo = (FacebookUserInfo)object;
            UserInfo userInfo = new UserInfo();
            userInfo.setId(facebookUserInfo.id);
            userInfo.setUsername(facebookUserInfo.username);
            userInfo.setEmail(facebookUserInfo.email);
            userInfo.setFullname(facebookUserInfo.name);
            userInfo.setFirstName(facebookUserInfo.first_name);
            userInfo.setLastName(facebookUserInfo.last_name);
            userInfo.setProfileLink(facebookUserInfo.link);
            userInfo.setGender(facebookUserInfo.gender);
            userInfo.setLocale(facebookUserInfo.locale);
            userInfo.setPictureLink("https://graph.facebook.com/" + facebookUserInfo.username + "/picture");
            return userInfo;
        }
        catch (MalformedURLException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to parse get user info url: " + exception.toString());
        }
        catch (ProtocolNotSuppException exception) {
            throw new DelegateAuthenticationException("internal_error", "Failed to parse get user info url: " + exception.toString());
        }
        catch (IOException exception) {
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Get user info request failed: " + exception.toString());
        }
        catch (ModuleException exception) {
            throw new DelegateAuthenticationException("internal_error", "Get user info request failed: " + exception.toString());
        }
        catch (SerializerException exception) {
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to desserialize google response on get user info request, cause: " + exception.toString());
        }
    }

    @Override
    public DelegateTokenInfo parseTokenReply(byte[] body) throws DelegateAuthenticationException {
        String query = new String(body);
        Trace.logDebug(this, "Token response: " + new String(body));
        try {
            Hashtable<String, String[]> params = HTTPUtils.parseQueryString(query, null);
            if (params.containsKey("access_token")) {
                DelegateTokenInfo tokenResponse = new DelegateTokenInfo(params.get("access_token")[0], this.getAccessTokenPrefix());
                if (params.containsKey("expires")) {
                    tokenResponse.setAccessTokenExpiresIn(Long.parseLong(params.get("expires")[0]));
                }
                return tokenResponse;
            }
            if (params.containsKey("error")) {
                String error = params.get("error")[0];
                String error_description = null;
                if (params.containsKey("error_description")) {
                    error_description = params.get("error_description")[0];
                }
                throw new DelegateAuthenticationException(error, error_description);
            }
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to parse token request response: " + query);
        }
        catch (Exception exception) {
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to parse token response: " + query);
        }
    }

    @Override
    protected String onGetScopes() {
        return this.configuration.getScopesComaDelimited();
    }

    @Override
    protected String getAccessTokenPrefix() {
        return "FBK";
    }

    public static class FacebookUserInfo {
        public String id;
        public String name;
        public String email;
        public String username;
        public String first_name;
        public String last_name;
        public String link;
        public String gender;
        public String locale;
        public Boolean verified;
    }
}

