/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;

public class DelegateTokenInfo {
    private String delegateToken;
    private Long expiresIn;
    private String tokenType;
    private transient String accessToken;
    private transient String accessTokenType;
    private transient String refreshToken;
    private transient Long accessTokenExpiresIn;

    public DelegateTokenInfo(String accessToken, String prefix) {
        this.accessToken = accessToken;
        String randomValue = OAuthTokenProvider.generateValue();
        this.delegateToken = randomValue + "_" + accessToken;
        if (prefix != null) {
            this.delegateToken = prefix + this.delegateToken;
        }
    }

    public String getDelegateToken() {
        return this.delegateToken;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public Long getAccessTokenExpiresIn() {
        return this.accessTokenExpiresIn;
    }

    public void setAccessTokenExpiresIn(Long accessTokenExpiresIn) {
        this.accessTokenExpiresIn = accessTokenExpiresIn;
    }
}

