/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthResponse;
import java.util.ArrayList;
import java.util.List;

public class DelegateAuthenticationResponse
extends OAuthResponse {
    public static DelegateAuthenticationResponse build(DelegateAuthenticationException exception) {
        DelegateAuthenticationResponse result = new DelegateAuthenticationResponse();
        result.responseStatus = 400;
        ErrorResponseObject responseData = new ErrorResponseObject();
        responseData.error = exception.getError();
        responseData.error_description = exception.getDescription();
        responseData.error_uri = exception.getErrorUri();
        result.responseObject = responseData;
        result.redirectURI = exception.getRedirectUri();
        if (result.redirectURI != null && result.redirectURI.length() > 0) {
            result.responseFormat = OAuthResponse.ResponseFormat.FRAGMENT;
        }
        return result;
    }

    public static DelegateAuthenticationResponse build(DelegateTokenInfo tokenInfo, String redirectUri) {
        DelegateAuthenticationResponse result = new DelegateAuthenticationResponse();
        result.responseStatus = 200;
        TokenResponseObject responseData = new TokenResponseObject();
        responseData.delegate_token = tokenInfo.getDelegateToken();
        responseData.token_type = tokenInfo.getTokenType();
        responseData.expires_in = tokenInfo.getExpiresIn();
        result.responseObject = responseData;
        result.redirectURI = redirectUri;
        if (result.redirectURI != null && result.redirectURI.length() > 0) {
            result.responseFormat = OAuthResponse.ResponseFormat.FRAGMENT;
        }
        return result;
    }

    public static DelegateAuthenticationResponse build(List<DelegateAuthenticationProvider> providers) {
        DelegateAuthenticationResponse result = new DelegateAuthenticationResponse();
        result.responseStatus = 200;
        DelegatesListResponseObject responseData = new DelegatesListResponseObject();
        for (DelegateAuthenticationProvider provider : providers) {
            responseData.delegates.add(new DelegatesListResponseObject.DelegateInfo(provider.getConfiguration().getName()));
        }
        result.responseObject = responseData;
        return result;
    }

    public static DelegateAuthenticationResponse build(UserInfo userInfo) {
        DelegateAuthenticationResponse result = new DelegateAuthenticationResponse();
        result.responseStatus = 200;
        result.responseObject = userInfo;
        return result;
    }

    public static class ErrorResponseObject {
        public String error = null;
        public String error_description = null;
        public String error_uri = null;
    }

    public static class TokenResponseObject {
        public String delegate_token = null;
        public Long expires_in = null;
        public String token_type = null;
    }

    public static class DelegatesListResponseObject {
        public List<DelegateInfo> delegates = new ArrayList<DelegateInfo>();

        public static class DelegateInfo {
            public String name;

            DelegateInfo(String name) {
                this.name = name;
            }
        }
    }
}

