/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthentication;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.DelegateAuthorizeCallbackServlet;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.DelegateAuthorizeServlet;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.DelegateListServlet;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.DelegateRevokeServlet;
import com.streamscape.sef.network.http.server.authentication.delegate.servlet.DelegateUserInfoServlet;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class DelegateAuthenticationProviderManager {
    public static final String ATTRIBUTE = DelegateAuthenticationProviderManager.class.getName();
    public static final String DELEGATE_URL = "/security/delegate/";
    public static final String DELEGATE_AUTHORIZE_URL = "/security/delegate/authorize";
    public static final String DELEGATE_CALLBACK_URL = "/security/delegate/callback";
    public static final String DELEGATE_LIST_URL = "/security/delegate/list";
    public static final String DELEGATE_USERINFO_URL = "/security/delegate/userinfo";
    public static final String DELEGATE_REVOKE_URL = "/security/delegate/revoke";
    public static final String DELEGATE_AUTH_TYPE = "Delegate";
    private HTTPAcceptorConfiguration configuration;
    private FabricConnectionsProviders fabricConnectionsProviders;
    private Map<String, DelegateAuthenticationProvider> providers = new HashMap<String, DelegateAuthenticationProvider>();
    private Map<String, DelegateAuthenticationContext> contextsByToken = new ConcurrentHashMap<String, DelegateAuthenticationContext>();
    private Map<String, List<DelegateAuthenticationContext>> contextsByUserId = new ConcurrentHashMap<String, List<DelegateAuthenticationContext>>();

    public void setConfiguration(HTTPAcceptorConfiguration configuration) {
        this.configuration = configuration;
    }

    public HTTPAcceptorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setFabricConnectionsProviders(FabricConnectionsProviders fabricConnectionsProviders) {
        this.fabricConnectionsProviders = fabricConnectionsProviders;
    }

    public void start(DelegateAuthenticationManager manager, RuntimeContext context) throws DelegateAuthenticationException {
        List<String> delegates = this.configuration.getOAuthDelegates();
        if (delegates == null || delegates.size() == 0) {
            return;
        }
        for (String delegate : delegates) {
            DelegateAuthentication authentication = manager.lookupAuthentication(delegate);
            if (authentication == null) {
                throw this.internalError("Configuration for '" + delegate + "' delegate authentication doesn't exist.");
            }
            String providerClassName = authentication.getProviderClass();
            if (providerClassName == null || providerClassName.length() == 0) {
                throw this.internalError("Delegate authentication " + delegate + " has null or empty provider class name.");
            }
            try {
                Class providesClass = ClassUtils.loadClass(providerClassName, context.getSystemClassLoaderChain());
                DelegateAuthenticationProvider provider = (DelegateAuthenticationProvider)providesClass.newInstance();
                provider.init(authentication, this);
                this.providers.put(delegate.toLowerCase(), provider);
            }
            catch (ClassNotFoundException exception) {
                throw this.internalError("Provider class '" + providerClassName + "' not found for delegate " + delegate + ", cause: " + exception.toString());
            }
            catch (InstantiationException exception) {
                throw this.internalError("Failed to create instance of '" + providerClassName + "' for delegate " + delegate + ", cause: " + exception.toString());
            }
            catch (IllegalAccessException exception) {
                throw this.internalError("Failed to create instance of '" + providerClassName + "' for delegate " + delegate + ", cause: " + exception.toString());
            }
        }
    }

    public void initServlets(ServletContextHandler context) {
        context.addServlet(DelegateAuthorizeServlet.class, DELEGATE_AUTHORIZE_URL);
        context.addServlet(DelegateAuthorizeCallbackServlet.class, "/security/delegate/callback/*");
        context.addServlet(DelegateListServlet.class, DELEGATE_LIST_URL);
        context.addServlet(DelegateUserInfoServlet.class, DELEGATE_USERINFO_URL);
        context.addServlet(DelegateRevokeServlet.class, DELEGATE_REVOKE_URL);
        context.getServletContext().setAttribute(ATTRIBUTE, (Object)this);
    }

    public static boolean isDelegateAuthenticationRequest(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null) {
            return false;
        }
        int delimiterPos = (authorizationHeader = authorizationHeader.trim()).indexOf(32);
        if (delimiterPos == -1) {
            return false;
        }
        String type = authorizationHeader.substring(0, delimiterPos).trim();
        return type.equalsIgnoreCase(DELEGATE_AUTH_TYPE);
    }

    public DelegateAuthenticationContext getContextByToken(String token) {
        return this.contextsByToken.get(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegateAuthenticationContext createContext(DelegateTokenInfo tokenInfo, UserInfo userInfo, DelegateAuthenticationProvider provider, HTTPCredentials credentials) throws DelegateAuthenticationException {
        Map<String, List<DelegateAuthenticationContext>> map = this.contextsByUserId;
        synchronized (map) {
            List<DelegateAuthenticationContext> contexts = this.contextsByUserId.get(userInfo.getId());
            if (contexts != null && contexts.size() > 0) {
                Iterator<DelegateAuthenticationContext> iterator = contexts.iterator();
                while (iterator.hasNext()) {
                    DelegateAuthenticationContext context = iterator.next();
                    if (context.getProvider() != provider) continue;
                    iterator.remove();
                    this.contextsByToken.remove(context.getTokenInfo().getDelegateToken());
                    Trace.logDebug(this, "delegate token context replaced.");
                    this.onRemoveContext(context);
                }
            } else {
                contexts = new ArrayList<DelegateAuthenticationContext>();
                this.contextsByUserId.put(userInfo.getId(), contexts);
            }
            DelegateAuthenticationContext context = new DelegateAuthenticationContext(tokenInfo, userInfo, provider, credentials);
            context.setLastAccessTime();
            contexts.add(context);
            this.contextsByToken.put(tokenInfo.getDelegateToken(), context);
            Trace.logInfo(this, "delegate token context created: token: " + context.getTokenInfo().getDelegateToken() + ", user id: " + context.getUserInfo().getId() + ", http username: " + context.getHttpCredentials().getUserName() + ", expiresin: " + context.getExpiresIn() + ", tokens conut: " + this.contextsByToken.size() + ", contextsByUserId.size(): " + this.contextsByUserId.size());
            return context;
        }
    }

    protected void onRemoveContext(DelegateAuthenticationContext context) {
        Trace.logInfo(this, "delegate token context removed, token " + context.getTokenInfo().getDelegateToken() + ", user id: " + context.getUserInfo().getId() + ", tokens count: " + this.contextsByToken.size() + ", contextsByUserId.size(): " + this.contextsByUserId.size());
        String boundSessionId = context.getBoundSessionId();
        if (boundSessionId != null) {
            this.fabricConnectionsProviders.removeConnection(boundSessionId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpired() {
        Iterator<Map.Entry<String, DelegateAuthenticationContext>> iterator = this.contextsByToken.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DelegateAuthenticationContext> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            iterator.remove();
            this.onRemoveContext(entry.getValue());
            Map<String, List<DelegateAuthenticationContext>> map = this.contextsByUserId;
            synchronized (map) {
                List<DelegateAuthenticationContext> contexts = this.contextsByUserId.get(entry.getValue().getUserInfo().getId());
                if (contexts != null) {
                    for (DelegateAuthenticationContext context : contexts) {
                        if (context.getTokenInfo() != entry.getValue().getTokenInfo()) continue;
                        iterator.remove();
                    }
                }
                if (contexts.size() == 0) {
                    this.contextsByUserId.remove(entry.getValue().getUserInfo().getId());
                }
            }
        }
    }

    public DelegateAuthenticationException internalError(String description) {
        return new DelegateAuthenticationException("internal_error", description);
    }

    public DelegateAuthenticationProvider getProvider(String name) {
        return this.providers.get(name.toLowerCase());
    }

    public List<DelegateAuthenticationProvider> getProviders() {
        return new ArrayList<DelegateAuthenticationProvider>(this.providers.values());
    }
}

