/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthentication;
import com.streamscape.sef.utils.Configurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DelegateAuthenticationManager
extends AbstractRuntimeFactory {
    protected static final String DELEGATE_AUTHENTICATIONS_NAMESPACE = "/sys/network/acceptors/http/oauth";
    private Map<String, DelegateAuthentication> authentications = new HashMap<String, DelegateAuthentication>();
    private Set<String> removedAuthentications = new HashSet<String>();
    private Configurator<DelegateAuthentication> configurator;

    public DelegateAuthenticationManager() throws FabricException {
        DelegateAuthenticationManager.checkContext();
        this.init();
    }

    public List<DelegateAuthentication> getAuthentications() {
        return new ArrayList<DelegateAuthentication>(this.authentications.values());
    }

    public List<String> listAuthentications() {
        return new ArrayList<String>(this.authentications.keySet());
    }

    public DelegateAuthentication lookupAuthentication(String name) {
        return this.authentications.get(name);
    }

    public boolean existsAuthentication(String name) {
        return this.authentications.containsKey(name);
    }

    public void addAuthentication(DelegateAuthentication authentication) {
        this.authentications.put(authentication.getName(), authentication);
    }

    public void removeAuthentication(String name) {
        this.authentications.remove(name);
        this.removedAuthentications.add(name);
    }

    public void saveAuthentication(DelegateAuthentication authentication) throws ObjectConfigurationException {
        this.configurator.bindObject(authentication.getName(), authentication);
        this.addAuthentication(authentication);
    }

    public void save() throws ObjectConfigurationException {
        for (String name : this.removedAuthentications) {
            this.configurator.unbindObject(name);
        }
        this.removedAuthentications.clear();
        for (DelegateAuthentication authentication : this.authentications.values()) {
            this.configurator.bindObject(authentication.getName(), authentication);
        }
    }

    protected void init() throws FabricException {
        DelegateAuthenticationManager.checkContext();
        try {
            this.configurator = new Configurator(DELEGATE_AUTHENTICATIONS_NAMESPACE);
            this.loadAuthentications();
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of DelegateAuthenticationFactory failed.", exception);
        }
    }

    protected void loadAuthentications() throws Exception {
        for (String objectName : this.configurator.listBoundNames()) {
            DelegateAuthentication object = this.configurator.loadObject(objectName);
            this.authentications.put(objectName, object);
        }
    }
}

