/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.ExpiredObject;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.UserInfo;

public class DelegateAuthenticationContext
extends ExpiredObject {
    public static final String ATTRIBUTE = DelegateAuthenticationContext.class.getName();
    private DelegateTokenInfo tokenInfo;
    private UserInfo userInfo;
    private DelegateAuthenticationProvider provider;
    private HTTPCredentials httpCredentials;
    private String boundSessionId;

    public DelegateAuthenticationContext(DelegateTokenInfo tokenInfo, UserInfo userInfo, DelegateAuthenticationProvider provider, HTTPCredentials credentials) {
        super(tokenInfo.getExpiresIn());
        this.tokenInfo = tokenInfo;
        this.userInfo = userInfo;
        this.provider = provider;
        this.httpCredentials = credentials;
    }

    public DelegateTokenInfo getTokenInfo() {
        return this.tokenInfo;
    }

    public DelegateAuthenticationProvider getProvider() {
        return this.provider;
    }

    public HTTPCredentials getHttpCredentials() {
        return this.httpCredentials;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public synchronized String bindToSession(String sessionId) {
        if (this.boundSessionId == null) {
            Trace.logDebug(this, "Delegate context for token " + this.tokenInfo.getDelegateToken() + " bound to session " + sessionId);
            this.boundSessionId = sessionId;
            return sessionId;
        }
        if (this.boundSessionId.equals(sessionId)) {
            return sessionId;
        }
        return this.boundSessionId;
    }

    public String getBoundSessionId() {
        return this.boundSessionId;
    }
}

