/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.sdo.CloneableDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DelegateAuthentication
extends CloneableDataObject {
    private String name = "Default";
    private String description = "Default Delegate Authentication configuration";
    private String providerClass = null;
    private String usersGroup = null;
    private String clientId = null;
    private String clientSecret = null;
    private List<String> scopes = new ArrayList<String>();
    private boolean storeProfile = false;
    private boolean profileTracking = false;
    private Properties parameters = new Properties();
    private long timeStamp = 0L;

    public DelegateAuthentication() {
        this.touch();
    }

    public DelegateAuthentication(String name) {
        this.name = name;
        this.touch();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getUsersGroup() {
        return this.usersGroup;
    }

    public void setUsersGroup(String usersGroup) {
        this.usersGroup = usersGroup;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getScopesSpaceDelimited() {
        return this.getScopes(" ");
    }

    public String getScopesComaDelimited() {
        return this.getScopes(",");
    }

    public String getScopes(String delimiter) {
        if (this.scopes == null || this.scopes.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String scope : this.scopes) {
            builder.append(scope).append(delimiter);
        }
        return builder.toString();
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void addScopes(String scope) {
        this.scopes.add(scope);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean isStoreProfile() {
        return this.storeProfile;
    }

    public void setStoreProfile(boolean storeProfile) {
        this.storeProfile = storeProfile;
    }

    public boolean getProfileTracking() {
        return this.profileTracking;
    }

    public void setProfileTracking(boolean profileTracking) {
        this.profileTracking = profileTracking;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    public String getParameter(String name) {
        return this.parameters.getProperty(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.setProperty(name, value);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }
}

