/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.delegate;

import com.streamscape.Trace;
import com.streamscape.lib.http.NVPair;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.authentication.delegate.CodeInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthentication;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProvider;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProviderManager;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateTokenInfo;
import com.streamscape.sef.network.http.server.authentication.delegate.Utils;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthErrorResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthTokenResponse;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.Hashtable;

public abstract class AbstractDelegateAuthenticationProvider
implements DelegateAuthenticationProvider {
    protected DelegateAuthentication configuration;
    protected DelegateAuthenticationProviderManager manager;
    protected String redirectUri;

    @Override
    public void init(DelegateAuthentication configuration, DelegateAuthenticationProviderManager manager) throws DelegateAuthenticationException {
        this.configuration = configuration;
        this.manager = manager;
        this.redirectUri = manager.getConfiguration().getResolvedUrlWithSchema() + "/security/delegate/callback/" + configuration.getName().toLowerCase();
    }

    @Override
    public DelegateAuthentication getConfiguration() {
        return this.configuration;
    }

    @Override
    public final String getRedirectUrl() {
        return this.redirectUri;
    }

    @Override
    public String getRequestCodeQuery(String state) {
        Object url = "?response_type=code";
        url = (String)url + "&client_id=" + this.configuration.getClientId();
        url = (String)url + "&redirect_uri=" + this.getRedirectUrl();
        String scopes = this.onGetScopes();
        if (scopes != null && scopes.length() > 0) {
            url = (String)url + "&scope=" + scopes;
        }
        if (state != null) {
            url = (String)url + "&state=" + state;
        }
        url = this.onGetRequestCodeQuery((String)url);
        return url;
    }

    protected String onGetRequestCodeQuery(String url) {
        return url;
    }

    protected String onGetScopes() {
        return this.configuration.getScopesSpaceDelimited();
    }

    @Override
    public CodeInfo parseCodeReply(String query) throws DelegateAuthenticationException {
        Hashtable<String, String[]> params = HTTPUtils.parseQueryString(query, null);
        Trace.logDebug(this, "Code response: " + query);
        if (params.containsKey("code")) {
            CodeInfo response = new CodeInfo(((String[])params.get("code"))[0]);
            if (params.containsKey("state")) {
                response.setState(((String[])params.get("state"))[0]);
            }
            return response;
        }
        if (params.containsKey("error")) {
            String errorDesciption = null;
            String errorUri = null;
            if (params.containsKey("error_description")) {
                errorDesciption = ((String[])params.get("error_description"))[0];
            }
            if (params.containsKey("error_uri")) {
                errorUri = ((String[])params.get("error_uri"))[0];
            }
            throw new DelegateAuthenticationException(((String[])params.get("error"))[0], errorDesciption, errorUri);
        }
        throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to parse code response query: " + query);
    }

    @Override
    public NVPair[] getRequestTokenPostData(String code) {
        NVPair[] data = new NVPair[]{new NVPair("code", code), new NVPair("client_id", this.configuration.getClientId()), new NVPair("redirect_uri", this.getRedirectUrl()), new NVPair("grant_type", "authorization_code"), this.configuration.getClientSecret() != null && this.configuration.getClientSecret().length() > 0 ? new NVPair("client_secret", this.configuration.getClientSecret()) : null};
        return this.onGetRequestTokenPostData(data);
    }

    protected NVPair[] onGetRequestTokenPostData(NVPair[] data) {
        return data;
    }

    @Override
    public DelegateTokenInfo parseTokenReply(byte[] body) throws DelegateAuthenticationException {
        JSONSerializer serializer = Utils.getJSONSerializer();
        try {
            Trace.logDebug(this, "Token response: " + new String(body));
            OAuthTokenResponse.ResponseObject response = (OAuthTokenResponse.ResponseObject)serializer.deserialize("OAuthTokenResponseObject", body);
            if (response != null && response.access_token != null) {
                DelegateTokenInfo tokenResponse = new DelegateTokenInfo(response.access_token, this.getAccessTokenPrefix());
                tokenResponse.setAccessTokenExpiresIn(response.expires_in);
                tokenResponse.setRefreshToken(response.refresh_token);
                tokenResponse.setAccessTokenType(response.token_type);
                return tokenResponse;
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Token response deserialization exception: " + exception.toString());
        }
        try {
            OAuthErrorResponse.ResponseObject error = (OAuthErrorResponse.ResponseObject)serializer.deserialize("OAuthErrorResponseObject", body);
            if (error != null && error.error != null) {
                throw new DelegateAuthenticationException(error.error, error.error_description, error.error_uri);
            }
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to parse token request response: " + new String(body));
        }
        catch (SerializerException exception) {
            Trace.logError(this, "Token response deserialization exception: " + exception.toString());
            throw new DelegateAuthenticationException("invalid_auth_server_response", "Failed to parse token response");
        }
    }

    @Override
    public String getRevokeTokenQuery(String token) throws DelegateAuthenticationException {
        return "?token=" + token;
    }

    protected abstract String getAccessTokenPrefix();
}

