/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenAuthenticatorService;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XSessionAuthenticator
extends AbstractAuthenticator {
    public static final String X_SESSION_TOKEN = "x-session-token";
    public static final String X_SESSION_TOKEN_MOVE_TO_COOKIE = "x-session-token-move-to-cookie";
    public static final String X_SESSION_TOKEN_REDIRECT = "x-session-token-redirect";
    private Authenticator authenticator;
    private ApiKeyTokenAuthenticatorService apiKeyTokenAuthenticatorService;

    public XSessionAuthenticator(Authenticator authenticator, ApiKeyTokenAuthenticatorService apiKeyTokenAuthenticatorService) {
        this.authenticator = authenticator;
        this.apiKeyTokenAuthenticatorService = apiKeyTokenAuthenticatorService;
    }

    @Override
    public Authenticator.Authentication authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.containsAuthentication(request) || AuthenticationHelper.isApiKeyTokenAuthorizeNativeRequest(request) || AuthenticationHelper.isSorRequest(request)) {
            String redirectTo;
            Authenticator.Authentication result = super.authenticate(request, response);
            if (result != Authenticator.Authentication.FAILED && (redirectTo = request.getParameter(X_SESSION_TOKEN_REDIRECT)) != null && redirectTo.length() > 0) {
                this.sendRedirect(request, response, redirectTo);
                result = Authenticator.Authentication.FAILED;
            }
            return result;
        }
        return this.authenticator.authenticate(request, response);
    }

    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String token = XSessionAuthenticator.getToken(request);
            if (token == null) {
                throw new Authenticator.UnauthorizedException("Missing x-session-token", "8004");
            }
            try {
                HTTPCredentials result = this.apiKeyTokenAuthenticatorService.authenticate(token, request.getMethod(), request.getRequestURI(), request);
                if (this.isTokenFromUrl(request) && request.getParameter(X_SESSION_TOKEN_MOVE_TO_COOKIE) != null) {
                    String redirectTo = request.getParameter(X_SESSION_TOKEN_REDIRECT);
                    Cookie cookie = new Cookie(X_SESSION_TOKEN, token);
                    cookie.setPath(redirectTo != null && redirectTo.length() > 0 ? redirectTo : request.getRequestURI());
                    cookie.setHttpOnly(true);
                    cookie.setSecure(false);
                    cookie.setMaxAge(-1);
                    response.addCookie(cookie);
                }
                return result;
            }
            catch (Authenticator.AccessDeniedException | Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new Authenticator.AuthenticationFailedException(exception.getMessage(), "8009");
            }
        }
        catch (Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
            Trace.logError(this, Utils.formatExceptionWithUnrepeatedCauses(exception));
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            this.onAuthenticationFailed(request, response, exception);
        }
        catch (Authenticator.AccessDeniedException exception) {
            Trace.logError(this, Utils.formatExceptionWithUnrepeatedCauses(exception));
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            this.onAccessDenied(request, response, exception);
        }
        return null;
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, (Authenticator.AuthenticationException)exception);
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, new Authenticator.AuthenticationFailedException(exception.getMessage(), "8007"));
    }

    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationException exception) throws IOException {
        this.setResponseCookies(request, response, exception);
        if (this.isTokenFromHeader(request)) {
            response.setHeader("WWW-Authenticate", "x-session-token error=\"" + exception.getMessage().replace("\"", "\\\"") + "\",state=\"" + exception.getState() + "\"");
            response.sendError(401);
        } else if (this.getHtmlLoginRedirect(request, exception) != null) {
            this.sendRedirect(request, response, this.getHtmlLoginRedirect(request, exception));
        } else {
            response.setStatus(406);
            response.getWriter().println(this.jsonError(406, exception));
        }
    }

    private void sendRedirect(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        String cloudfrontOrigin = request.getHeader("cloudfront-origin");
        if (cloudfrontOrigin != null) {
            location = cloudfrontOrigin + (String)location;
        }
        response.sendRedirect((String)location);
    }

    protected void onAccessDenied(HttpServletRequest request, HttpServletResponse response, Authenticator.AccessDeniedException exception) throws IOException {
        this.setResponseCookies(request, response, exception);
        if (this.getHtmlLoginRedirect(request, exception) != null) {
            this.sendRedirect(request, response, this.getHtmlLoginRedirect(request, exception));
        } else {
            response.setStatus(403);
            response.getWriter().println(this.jsonError(403, exception));
        }
    }

    private void setResponseCookies(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationException exception) {
        String token = XSessionAuthenticator.getTokenFromCookie(request);
        if (token != null && (exception.getState().equals("8002") || exception.getState().equals("8003"))) {
            Arrays.asList(Optional.ofNullable(request.getCookies()).orElse(new Cookie[0])).stream().filter(c -> c.getName().equals(X_SESSION_TOKEN)).forEach(c -> c.setMaxAge(0));
            Cookie cookie = new Cookie(X_SESSION_TOKEN, token);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private String escapeStringForJson(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "\\\"");
    }

    private boolean isTokenFromHeader(HttpServletRequest request) {
        return request.getHeader(X_SESSION_TOKEN) != null;
    }

    private boolean isTokenFromUrl(HttpServletRequest request) {
        return request.getParameter(X_SESSION_TOKEN) != null;
    }

    private boolean isTokenFromCookie(HttpServletRequest request) {
        return XSessionAuthenticator.getTokenFromCookie(request) != null;
    }

    public static String getTokenFromCookie(HttpServletRequest request) {
        return request.getCookies() != null ? (String)Arrays.asList(request.getCookies()).stream().filter(c -> c.getName().equals(X_SESSION_TOKEN)).map(c -> c.getValue()).findFirst().orElse(null) : null;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(X_SESSION_TOKEN);
        if (token == null) {
            token = request.getParameter(X_SESSION_TOKEN);
        }
        if (token == null && request.getCookies() != null) {
            token = XSessionAuthenticator.getTokenFromCookie(request);
        }
        return token;
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        return XSessionAuthenticator.getToken(request) != null;
    }

    public static String getTokenIfAuthenticated(HttpServletRequest request) {
        HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
        if (credentials == null || !(credentials.getDigestCalculator() instanceof ApiKeyTokenDigestCalculator)) {
            return null;
        }
        return XSessionAuthenticator.getToken(request);
    }

    private String jsonError(int status, Authenticator.AuthenticationException exception) {
        return "{\"status\":" + status + ", \"state\":\"" + exception.getState() + "\", \"message\":\"" + this.escapeStringForJson(exception.getMessage()) + "\"}";
    }

    private String getHtmlLoginRedirect(HttpServletRequest request, Authenticator.AuthenticationException exception) {
        if (this.isTokenFromHeader(request) || this.isTokenFromUrl(request)) {
            return null;
        }
        if (AuthenticationHelper.isSorRequest(request) && !AuthenticationHelper.isSorLoginRequest(request)) {
            String error = null;
            if (!exception.getState().equals("8004")) {
                error = exception.getMessage();
            }
            return (AuthenticationHelper.isSorQuiltRequest(request) ? "/sorquilt" : "/sor") + "/login?origin=" + request.getRequestURI() + (String)(error != null ? "&error=" + HTTPUtils.encodeString(error) : "");
        }
        return null;
    }

    public static class XSessionAuthenticationState {
        public static final String AUTH_FAILED = "8001";
        public static final String TOKEN_EXPIRED = "8002";
        public static final String TOKEN_NOT_FOUND = "8003";
        public static final String TOKEN_MISSING = "8004";
        public static final String ACCESS_DENIED = "8006";
        public static final String SESSION_EXPIRED = "8007";
        public static final String APPLICATION_DOESNT_EXIST = "8008";
        public static final String INTERNAL_ERROR = "8009";
    }
}

