/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.jwt.JWTAuthenticatorServiceImpl;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XResourceAuthenticator
extends AbstractAuthenticator {
    public static final String X_RESOURCE_TOKEN = "x-resource-token";

    @Override
    public Authenticator.Authentication authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return super.authenticate(request, response);
    }

    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String token = XResourceAuthenticator.getToken(request);
            if (token == null) {
                throw new Authenticator.UnauthorizedException("Missing x-resource-token", "8005");
            }
            try {
                return new JWTAuthenticatorServiceImpl().authenticate(token, request.getMethod(), request.getRequestURI(), request);
            }
            catch (Authenticator.AccessDeniedException | Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new Authenticator.AuthenticationFailedException(exception.getMessage(), "8008");
            }
        }
        catch (Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAuthenticationFailed(request, response, exception);
        }
        catch (Authenticator.AccessDeniedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAccessDenied(request, response, exception);
        }
        return null;
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, (Authenticator.AuthenticationException)exception);
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, new Authenticator.AuthenticationFailedException(exception.getMessage(), "8007"));
    }

    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationException exception) throws IOException {
        this.setResponseCookies(request, response, exception);
        if (this.isTokenFromHeader(request)) {
            response.setHeader("WWW-Authenticate", "x-resourse-token error=\"" + exception.getMessage().replace("\"", "\\\"") + "\",state=\"" + exception.getState() + "\"");
            response.sendError(401);
        } else {
            response.setStatus(406);
            response.getWriter().println(this.jsonError(406, exception));
        }
    }

    protected void onAccessDenied(HttpServletRequest request, HttpServletResponse response, Authenticator.AccessDeniedException exception) throws IOException {
        this.setResponseCookies(request, response, exception);
        response.setStatus(403);
        response.getWriter().println(this.jsonError(403, exception));
    }

    private void setResponseCookies(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationException exception) {
        String token = XResourceAuthenticator.getTokenFromCookie(request);
        if (token != null && (exception.getState().equals("8002") || exception.getState().equals("8004"))) {
            Arrays.asList(Optional.ofNullable(request.getCookies()).orElse(new Cookie[0])).stream().filter(c -> c.getName().equals(X_RESOURCE_TOKEN)).forEach(c -> c.setMaxAge(0));
            Cookie cookie = new Cookie(X_RESOURCE_TOKEN, token);
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private String escapeStringForJson(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "\\\"");
    }

    private boolean isTokenFromHeader(HttpServletRequest request) {
        return request.getHeader(X_RESOURCE_TOKEN) != null;
    }

    private boolean isTokenFromUrl(HttpServletRequest request) {
        return request.getParameter(X_RESOURCE_TOKEN) != null;
    }

    private boolean isTokenFromCookie(HttpServletRequest request) {
        return XResourceAuthenticator.getTokenFromCookie(request) != null;
    }

    public static String getTokenFromCookie(HttpServletRequest request) {
        return request.getCookies() != null ? (String)Arrays.asList(request.getCookies()).stream().filter(c -> c.getName().equals(X_RESOURCE_TOKEN)).map(c -> c.getValue()).findFirst().orElse(null) : null;
    }

    public static String getToken(HttpServletRequest request) {
        String token = request.getHeader(X_RESOURCE_TOKEN);
        if (token == null) {
            token = request.getParameter(X_RESOURCE_TOKEN);
        }
        if (token == null && request.getCookies() != null) {
            token = XResourceAuthenticator.getTokenFromCookie(request);
        }
        return token;
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        return XResourceAuthenticator.getToken(request) != null;
    }

    public static String getTokenIfAuthenticated(HttpServletRequest request) {
        HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
        if (credentials == null || !(credentials.getDigestCalculator() instanceof ApiKeyTokenDigestCalculator)) {
            return null;
        }
        return XResourceAuthenticator.getToken(request);
    }

    private String jsonError(int status, Authenticator.AuthenticationException exception) {
        return "{\"status\":" + status + ", \"state\":\"" + exception.getState() + "\", \"message\":\"" + this.escapeStringForJson(exception.getMessage()) + "\"}";
    }

    public static class XResourceAuthenticationState {
        public static final String AUTH_FAILED = "8001";
        public static final String TOKEN_EXPIRED = "8002";
        public static final String TOKEN_NOT_VALID_YET = "8003";
        public static final String TOKEN_IS_INVALID = "8004";
        public static final String TOKEN_MISSING = "8005";
        public static final String ACCESS_DENIED = "8006";
        public static final String SESSION_EXPIRED = "8007";
        public static final String INTERNAL_ERROR = "8008";
    }
}

