/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RealmManager {
    private HTTPAcceptor acceptor;

    public RealmManager(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public RealmInfo getRealmInfo(String path) {
        return RealmManager.getRealmInfo(this.acceptor.getConfiguration().getRealms(), path);
    }

    protected RealmInfo getRealmInfoForRequest(HttpServletRequest request) {
        RealmInfo realmInfo = this.getRealmInfo(request.getRequestURI());
        if (realmInfo == null && AuthenticationHelper.isSecurityRequest(request)) {
            realmInfo = new RealmInfo("Security", this.acceptor.getRuntimeContext());
        }
        return realmInfo;
    }

    protected boolean existRealmInfoForRequest(HttpServletRequest request) {
        return this.getRealmInfo(request.getRequestURI()) != null;
    }

    public static RealmInfo getRealmInfo(HashMap<String, RealmInfo> realms, String path) {
        if (path != null && ((String)path).toLowerCase().startsWith("/sorquilt")) {
            path = "/sor" + ((String)path).substring("/sorquilt".length());
        }
        int maxLength = 0;
        RealmInfo matchingRealm = null;
        path = UriMatcher.normalizeUriWithLastSlashRemove((String)path);
        for (Map.Entry<String, RealmInfo> realm : realms.entrySet()) {
            String realmPath = realm.getKey().replaceAll("\\*", ".*");
            if (path == null || !((String)path).matches(realmPath + ".*") || realmPath.length() <= maxLength) continue;
            maxLength = realmPath.length();
            matchingRealm = realm.getValue();
        }
        return matchingRealm;
    }
}

