/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RealmManager;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import javax.servlet.http.HttpServletRequest;

public class RealmAuthenticator {
    private RealmManager manager;

    public RealmAuthenticator(RealmManager manager) {
        this.manager = manager;
    }

    public void authenticate(HTTPCredentials credentials, HttpServletRequest request) throws Authenticator.AuthenticationFailedException {
        if (credentials.isAnonymousUser() && AuthenticationHelper.isAnonymousRequest(request)) {
            return;
        }
        RealmInfo realmInfo = this.manager.getRealmInfoForRequest(request);
        if (realmInfo != null && !realmInfo.checkUser(credentials.getUserName()) && !AuthenticationHelper.isSecurityRequest(request)) {
            if (AuthenticationHelper.isAnonymousRealm(realmInfo)) {
                credentials.setUserName("anonymous");
                credentials.setCredentials("anonymous");
            } else {
                throw new Authenticator.AuthenticationFailedException("Authentication failed for user '" + credentials.getUserName() + "', not allowed in realm '" + realmInfo.getRealmName() + "'.", "7002");
            }
        }
        credentials.setRealmInfo(realmInfo);
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        return !AuthenticationHelper.isSorLoginRequest(request) && !AuthenticationHelper.isApiKeyTokenAuthorizeNativeRequest(request) && this.manager.existRealmInfoForRequest(request);
    }

    public RealmManager getManager() {
        return this.manager;
    }
}

