/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthAccessToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthErrorResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OAuth2Authenticator
extends AbstractAuthenticator {
    private OAuthTokenProvider provider;
    private Boolean shareTokenBetweenSessions;

    public OAuth2Authenticator(OAuthTokenProvider provider, Boolean shareTokenBetweenSessions) {
        this.provider = provider;
        this.shareTokenBetweenSessions = shareTokenBetweenSessions;
    }

    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String authorizationHeader = request.getHeader("Authorization");
            if (authorizationHeader == null) {
                throw new OAuthErrorException("invalid_request", "Authorization header is missing.");
            }
            if (authorizationHeader.isEmpty()) {
                throw new OAuthErrorException("invalid_request", "Authorization header is emty.");
            }
            int spacepos = authorizationHeader.indexOf(" ");
            if (spacepos == -1) {
                throw new OAuthErrorException("invalid_request", "Wrong authorization header, should be of type : Bearer");
            }
            String httpAuthType = authorizationHeader.substring(0, spacepos);
            String decodedToken = authorizationHeader.substring(spacepos + 1);
            if (!httpAuthType.equalsIgnoreCase("Bearer")) {
                throw new OAuthErrorException("invalid_request", "Wrong authorization type, should be: Bearer");
            }
            OAuthAccessToken token = this.provider.getAccessToken(decodedToken);
            if (token == null || token.isExpired()) {
                throw new OAuthErrorException("invalid_token", "The access token is expired or invalid.");
            }
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            if (this.shareTokenBetweenSessions.booleanValue()) {
                token.addSessionId(sessionId);
            } else if (!token.setAndGetSessionId(sessionId).equals(sessionId)) {
                throw new OAuthErrorException("invalid_token", "OAuth token is bound to another session.");
            }
            token.setLastAccessTime();
            return HTTPCredentials.buildDigest(token.getUsername(), token.getPassword());
        }
        catch (OAuthErrorException exception) {
            Trace.logError(this, exception.getMessage());
            this.reply(request, response, exception);
            return null;
        }
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        return header != null && header.trim().startsWith("Bearer");
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.reply(request, response, new OAuthErrorException("invalid_token", "Authentication failed: " + exception.getMessage()));
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.reply(request, response, new OAuthErrorException("invalid_token", "Authentication failed: " + exception.getMessage()));
    }

    protected void reply(HttpServletRequest request, HttpServletResponse response, OAuthErrorException exception) throws IOException {
        String authreq = this.getAuthRequest(request, exception);
        response.setHeader("WWW-Authenticate", authreq);
        response.setStatus(401);
        response.getOutputStream().write(OAuthErrorResponse.build(exception).jsonResponse().getBytes());
        response.flushBuffer();
    }

    protected String getAuthRequest(HttpServletRequest request, OAuthErrorException exception) {
        Object error = OAuthErrorResponse.build(exception).headerResponse();
        if (!((String)error).equals("")) {
            error = ", " + (String)error;
        }
        return "Bearer realm=\"" + this.realmAuthenticator.getManager().getRealmInfoForRequest(request).getRealmName() + "\"" + (String)error;
    }
}

