/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.sef.network.http.server.config.HTTPAuthenticationType;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.HttpSecurityDigestCalculator;
import com.streamscape.sef.security.MD5DigestCalculator;
import java.util.HashMap;
import java.util.Map;

public class HTTPCredentials {
    public static final String ATTRIBUTE = HTTPCredentials.class.getName();
    private String userName;
    private String credentials;
    private Map<String, String> keys;
    private RealmInfo realmInfo;
    private DigestCalculator digestCalculator;

    public static HTTPCredentials buildDigest(String username, String password) {
        HTTPCredentials credentials = new HTTPCredentials();
        credentials.setUserName(username);
        credentials.setCredentials(HTTPCredentials.isWrappedCredentials(password) ? HTTPCredentials.unwrapCredentials(password) : HttpSecurityDigestCalculator.calculateDigest(username, password));
        credentials.setDigestCalculator(new HttpSecurityDigestCalculator());
        return credentials;
    }

    public static String wrapCredentials(String credentials) {
        return "--1-f-3" + credentials + "=2-3-4";
    }

    public static boolean isWrappedCredentials(String credentials) {
        return credentials.startsWith("--1-f-3") && credentials.endsWith("=2-3-4");
    }

    public static String unwrapCredentials(String credentials) {
        if (HTTPCredentials.isWrappedCredentials(credentials)) {
            credentials = credentials.substring(7, credentials.length() - 6);
        }
        return credentials;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public void addKey(String key, String value) {
        if (this.keys == null) {
            this.keys = new HashMap<String, String>();
        }
        this.keys.put(key, value);
    }

    public boolean isAnonymousUser() {
        return this.userName != null && this.userName.equals("anonymous");
    }

    public void setRealmInfo(RealmInfo realmInfo) {
        this.realmInfo = realmInfo;
    }

    public RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    public HTTPAuthenticationType getAuthenticationType() {
        return this.digestCalculator instanceof MD5DigestCalculator ? HTTPAuthenticationType.DIGEST : HTTPAuthenticationType.BASIC;
    }

    public void setDigestCalculator(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public DigestCalculator getDigestCalculator() {
        return this.digestCalculator;
    }
}

