/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DropBoxResourceAuthenticator
extends AbstractAuthenticator {
    private AbstractAuthenticator commonAuthenticator;

    public DropBoxResourceAuthenticator(AbstractAuthenticator commonAuthenticator) {
        this.commonAuthenticator = commonAuthenticator;
    }

    @Override
    public Authenticator.Authentication authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DropBoxSharedResources.DropBoxSharedResource dropBoxSharedResource = this.getDropBoxSharedResource(request);
            if (dropBoxSharedResource.getShareMethod() == DropBoxSharedResources.DropBoxSharedResource.ShareMethod.PUBLIC) {
                return this.commonAuthenticator.authenticate(request, response);
            }
            return super.authenticate(request, response);
        }
        catch (Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAuthenticationFailed(request, response, exception);
        }
        catch (Authenticator.AccessDeniedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAccessDenied(request, response, exception);
        }
        return Authenticator.Authentication.FAILED;
    }

    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            DropBoxSharedResources.DropBoxSharedResource dropBoxSharedResource = this.getDropBoxSharedResource(request);
            HTTPCredentials credentials = new HTTPCredentials();
            credentials.setUserName(dropBoxSharedResource.getUsername());
            credentials.setCredentials(dropBoxSharedResource.getUsername());
            credentials.setDigestCalculator((userName, user, parameters) -> dropBoxSharedResource.getUsername());
            return credentials;
        }
        catch (Authenticator.AuthenticationFailedException | Authenticator.UnauthorizedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAuthenticationFailed(request, response, exception);
        }
        catch (Authenticator.AccessDeniedException exception) {
            Trace.logError(this, exception.getMessage());
            this.onAccessDenied(request, response, exception);
        }
        return null;
    }

    private DropBoxSharedResources.DropBoxSharedResource getDropBoxSharedResource(HttpServletRequest request) throws Authenticator.UnauthorizedException, Authenticator.AuthenticationFailedException, Authenticator.AccessDeniedException {
        String dropBoxName = DropBoxResourceAuthenticator.getDropBoxName(request);
        if (dropBoxName == null) {
            throw new Authenticator.UnauthorizedException("Missing DropBox name or invalid request", "8001");
        }
        String resourceId = DropBoxResourceAuthenticator.getResourceId(request);
        if (resourceId == null) {
            throw new Authenticator.UnauthorizedException("Missing token or invalid request", "8001");
        }
        DropBox dropBox = RuntimeContext.getInstance().getDropBoxManagerRemote().lookupDropBox(dropBoxName);
        if (dropBox == null) {
            throw new Authenticator.AuthenticationFailedException("DropBox with specified name not found", "8001");
        }
        DropBoxSharedResources.DropBoxSharedResource dropBoxSharedResource = dropBox.getSharedResources().getResourceById(resourceId);
        if (dropBoxSharedResource == null) {
            throw new Authenticator.AuthenticationFailedException("DropBox resource with specified ID not found", "8001");
        }
        if (dropBoxSharedResource.isExpired()) {
            throw new Authenticator.AccessDeniedException("This resource has expired", "8006");
        }
        return dropBoxSharedResource;
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, (Authenticator.AuthenticationException)exception);
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.onAuthenticationFailed(request, response, new Authenticator.AuthenticationFailedException(exception.getMessage(), "8007"));
    }

    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationException exception) throws IOException {
        response.setStatus(406);
        response.getWriter().println(this.jsonError(406, exception));
    }

    protected void onAccessDenied(HttpServletRequest request, HttpServletResponse response, Authenticator.AccessDeniedException exception) throws IOException {
        response.setStatus(403);
        response.getWriter().println(this.jsonError(403, exception));
    }

    private String escapeStringForJson(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "\\\"");
    }

    public static String getDropBoxName(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (!path.toLowerCase().startsWith("/dropbox/share/")) {
            return null;
        }
        int pos = (path = path.substring("/dropbox/share/".length())).indexOf("/");
        if (pos <= 0) {
            return null;
        }
        String dropBoxName = path.substring(0, pos);
        if (dropBoxName.length() == 0) {
            return null;
        }
        return dropBoxName;
    }

    public static String getResourceId(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (!path.toLowerCase().startsWith("/dropbox/share/")) {
            return null;
        }
        int pos = (path = path.substring("/dropbox/share/".length())).indexOf("/");
        if (pos <= 0) {
            return null;
        }
        String token = path.substring(pos + 1);
        if (token.length() == 0) {
            return null;
        }
        return token;
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        return DropBoxResourceAuthenticator.getResourceId(request) != null;
    }

    public static String getTokenIfAuthenticated(HttpServletRequest request) {
        HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
        if (credentials == null || !(credentials.getDigestCalculator() instanceof ApiKeyTokenDigestCalculator)) {
            return null;
        }
        return DropBoxResourceAuthenticator.getResourceId(request);
    }

    private String jsonError(int status, Authenticator.AuthenticationException exception) {
        return "{\"status\":" + status + ", \"state\":\"" + exception.getState() + "\", \"message\":\"" + this.escapeStringForJson(exception.getMessage()) + "\"}";
    }

    public static class DropBoxResourceAuthenticatorState {
        public static final String RESOURCE_ID_MISSING = "8001";
        public static final String DROPBOX_NAME_MISSING = "8002";
        public static final String DROPBOX_NOT_FOUND = "8003";
        public static final String RESOURCE_NOT_FOUND = "8004";
        public static final String ACCESS_DENIED = "8005";
        public static final String RESOURCE_EXPIRED = "8006";
    }
}

