/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.sef.network.http.server.authentication.AbstractWwwAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.security.MD5DigestCalculator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DigestAuthenticator
extends AbstractWwwAuthenticator {
    private SecureRandom random = new SecureRandom();
    private ConcurrentMap<String, Nonce> nonceMap = new ConcurrentHashMap<String, Nonce>();
    private Queue<Nonce> nonceQueue = new ConcurrentLinkedQueue<Nonce>();
    private long maxNonceAgeMs = 60000L;

    @Override
    protected HTTPCredentials obtainCredentialsFromAuthInfo(HttpServletRequest request, String httpAuthType, String authInfo, boolean isAuthInfoFromQuery) throws Authenticator.UnauthorizedException {
        if (!httpAuthType.equalsIgnoreCase("digest")) {
            throw new Authenticator.UnauthorizedException("Wrong authentication type: " + httpAuthType + ", should be digest.", "7004");
        }
        String nonce = this.getAndCheckNonce(request, authInfo, isAuthInfoFromQuery);
        HTTPCredentials credentials = new HTTPCredentials();
        credentials.setDigestCalculator(new MD5DigestCalculator());
        credentials.setUserName(this.getAuthParameter("username", authInfo, isAuthInfoFromQuery));
        credentials.setCredentials(this.getAuthParameter("response", authInfo, isAuthInfoFromQuery));
        HashMap<String, String> securityKeys = new HashMap<String, String>();
        securityKeys.put("realm", this.getAuthParameter("realm", authInfo, isAuthInfoFromQuery));
        securityKeys.put("method", isAuthInfoFromQuery ? "POST" : request.getMethod());
        securityKeys.put("uri", this.getAuthParameter("uri", authInfo, isAuthInfoFromQuery));
        securityKeys.put("nonce", nonce);
        credentials.setKeys(securityKeys);
        if (credentials.getUserName() == null) {
            throw new Authenticator.UnauthorizedException("Wrong authentication format: " + authInfo, "7006");
        }
        return credentials;
    }

    @Override
    protected String getAuthType() {
        return "digest";
    }

    @Override
    protected String getAuthRequest(HttpServletRequest request, boolean isAuthInfoFromQuery) {
        return "digest" + this.getAuthInfoDelimiter(isAuthInfoFromQuery) + "realm=\"" + this.realmAuthenticator.getManager().getRealmInfoForRequest(request).getRealmName() + "\",nonce=\"" + this.newNonce(request) + "\"";
    }

    private String newNonce(HttpServletRequest request) {
        Nonce nonce;
        String s = this.getNonceFromSession(request);
        if (s != null) {
            return s;
        }
        do {
            byte[] nounce = new byte[24];
            this.random.nextBytes(nounce);
            try {
                nonce = new Nonce(CryptoUtils.calculateDigest(nounce, "MD5"), System.currentTimeMillis());
            }
            catch (NoSuchAlgorithmException exception) {
                Trace.logException(this, exception, false);
                return null;
            }
        } while (this.nonceMap.putIfAbsent(nonce.nonce, nonce) != null);
        this.nonceQueue.add(nonce);
        return nonce.nonce;
    }

    private String getAndCheckNonce(HttpServletRequest request, String authInfo, boolean isAuthInfoFromQuery) throws Authenticator.UnauthorizedException {
        long expired = System.currentTimeMillis() - this.maxNonceAgeMs;
        Nonce nonce = this.nonceQueue.peek();
        while (nonce != null && nonce.timestamp < expired) {
            this.nonceQueue.remove(nonce);
            this.nonceMap.remove(nonce.nonce);
            nonce = this.nonceQueue.peek();
        }
        String nonces = this.getAuthParameter("nonce", authInfo, isAuthInfoFromQuery);
        if (nonces == null) {
            throw new Authenticator.UnauthorizedException("Nonce not specified.", "7007");
        }
        nonce = (Nonce)this.nonceMap.get(nonces);
        if (nonce != null) {
            this.nonceQueue.remove(nonce);
            this.nonceMap.remove(nonce.nonce);
        } else {
            String s = this.getNonceFromSession(request);
            if (s == null || !s.equals(nonces)) {
                throw new Authenticator.UnauthorizedException("Invalid nonce specified.", "7007");
            }
        }
        return nonces;
    }

    private String getNonceFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("nonce") != null) {
            return (String)session.getAttribute("nonce");
        }
        return null;
    }

    @Override
    protected void onAuthenticationSucceeded(HttpServletRequest request, HTTPCredentials credentials) {
        if (credentials.getKeys() != null) {
            request.getSession(true).setAttribute("nonce", credentials.getKeys().get("nonce"));
        }
    }

    private String getAuthParameter(String paramname, String authInfo, boolean isAuthInfoFromQuery) {
        int startIndex;
        if (authInfo == null) {
            return null;
        }
        String quoteSymbol = "\"";
        if (isAuthInfoFromQuery) {
            quoteSymbol = "";
        }
        if ((startIndex = authInfo.indexOf((String)(paramname = (String)paramname + "=" + quoteSymbol))) == -1) {
            return null;
        }
        startIndex += ((String)paramname).length();
        int endIndex = -1;
        if (quoteSymbol.isEmpty()) {
            endIndex = authInfo.indexOf(",", startIndex);
            if (endIndex == -1) {
                endIndex = authInfo.length();
            }
        } else {
            endIndex = authInfo.indexOf(quoteSymbol, startIndex);
        }
        if (endIndex == -1) {
            return null;
        }
        return authInfo.substring(startIndex, endIndex);
    }

    static class Nonce {
        String nonce;
        long timestamp;

        Nonce(String nonce, long timestamp) {
            this.nonce = nonce;
            this.timestamp = timestamp;
        }
    }
}

