/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationException;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProviderManager;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DelegateAuthenticator
extends AbstractAuthenticator {
    private DelegateAuthenticationProviderManager manager;

    DelegateAuthenticator(DelegateAuthenticationProviderManager manager) {
        this.manager = manager;
    }

    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String authorizationHeader = request.getHeader("Authorization");
            if (authorizationHeader == null) {
                throw new DelegateAuthenticationException("invalid_request", "Authorization header is missing.");
            }
            if (authorizationHeader.isEmpty()) {
                throw new DelegateAuthenticationException("invalid_request", "Authorization header is empty.");
            }
            int spacepos = authorizationHeader.indexOf(" ");
            if (spacepos == -1) {
                throw new DelegateAuthenticationException("invalid_request", "Wrong authorization header, should be of type : Delegate");
            }
            String httpAuthType = authorizationHeader.substring(0, spacepos);
            String token = authorizationHeader.substring(spacepos + 1);
            if (!httpAuthType.equalsIgnoreCase("Delegate")) {
                throw new DelegateAuthenticationException("invalid_request", "Invalid authentication type '" + httpAuthType + "' , should be 'Delegate'.");
            }
            DelegateAuthenticationContext context = this.manager.getContextByToken(token);
            if (context == null || context.isExpired()) {
                throw new DelegateAuthenticationException("access_denied", "Token is expired or invalid");
            }
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            if (!context.bindToSession(sessionId).equals(sessionId)) {
                throw new DelegateAuthenticationException("access_denied", "Delegate token is bound to another session.");
            }
            request.setAttribute(DelegateAuthenticationContext.ATTRIBUTE, context);
            return context.getHttpCredentials();
        }
        catch (DelegateAuthenticationException exception) {
            Trace.logError(this, exception.getMessage());
            this.reply(request, response, exception);
            return null;
        }
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        return header != null && header.trim().startsWith("Delegate");
    }

    @Override
    protected void onAuthenticationSucceeded(HttpServletRequest request, HTTPCredentials credentials) {
        ((DelegateAuthenticationContext)request.getAttribute(DelegateAuthenticationContext.ATTRIBUTE)).setLastAccessTime();
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.reply(request, response, new DelegateAuthenticationException("access_denied", "Authentication failed: " + exception.getMessage()));
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        this.reply(request, response, new DelegateAuthenticationException("access_denied", "Authentication failed: " + exception.getMessage()));
    }

    protected void reply(HttpServletRequest request, HttpServletResponse response, DelegateAuthenticationException exception) throws IOException {
        String authreq = this.getAuthRequest(request, exception);
        response.setHeader("WWW-Authenticate", authreq);
        response.setStatus(401);
        response.getOutputStream().write(DelegateAuthenticationResponse.build(exception).jsonResponse().getBytes());
        response.flushBuffer();
    }

    protected String getAuthRequest(HttpServletRequest request, DelegateAuthenticationException exception) {
        Object error = DelegateAuthenticationResponse.build(exception).headerResponse();
        if (!((String)error).equals("")) {
            error = ", " + (String)error;
        }
        return "Delegate realm=\"" + this.realmAuthenticator.getManager().getRealmInfoForRequest(request).getRealmName() + "\"" + (String)error;
    }
}

