/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.lib.utils.Base64;
import com.streamscape.sef.network.http.server.authentication.AbstractWwwAuthenticator;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import javax.servlet.http.HttpServletRequest;

public class BasicAuthenticator
extends AbstractWwwAuthenticator {
    @Override
    protected HTTPCredentials obtainCredentialsFromAuthInfo(HttpServletRequest request, String httpAuthType, String authInfo, boolean isAuthInfoFromQuery) throws Authenticator.UnauthorizedException {
        String decodedAuthInfo;
        if (!httpAuthType.equalsIgnoreCase("basic")) {
            throw new Authenticator.UnauthorizedException("Wrong authentication type: " + httpAuthType + ", should be basic.", "7004");
        }
        try {
            byte[] decodedAuthInfoBytes = Base64.decode(authInfo, request.getCharacterEncoding());
            if (decodedAuthInfoBytes == null) {
                throw new Authenticator.UnauthorizedException("Failed to decode authorization info.", "7006");
            }
            decodedAuthInfo = new String(decodedAuthInfoBytes);
        }
        catch (Authenticator.UnauthorizedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new Authenticator.UnauthorizedException("Failed to decode authorization info. Cause: " + exception.getMessage(), "7006");
        }
        int delimiterPos = decodedAuthInfo.indexOf(58);
        if (delimiterPos == -1) {
            throw new Authenticator.UnauthorizedException("Wrong authentication format: " + decodedAuthInfo, "7006");
        }
        return HTTPCredentials.buildDigest(decodedAuthInfo.substring(0, delimiterPos), decodedAuthInfo.substring(delimiterPos + 1));
    }

    @Override
    protected String getAuthRequest(HttpServletRequest request, boolean isAuthInfoFromQuery) {
        return "basic" + this.getAuthInfoDelimiter(isAuthInfoFromQuery) + "realm=\"" + this.realmAuthenticator.getManager().getRealmInfoForRequest(request).getRealmName() + "\"";
    }

    @Override
    protected String getAuthType() {
        return "basic";
    }
}

