/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.sef.FabricException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface Authenticator {
    public static final Authenticator NO_NEED = (request, response) -> Authentication.NO_NEED;
    public static final Authenticator OK = (request, response) -> Authentication.OK;
    public static final Authenticator FAILED = (request, response) -> Authentication.FAILED;

    public Authentication authenticate(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public static enum Authentication {
        NO_NEED,
        OK,
        FAILED;

    }

    public static class AccessDeniedException
    extends AuthenticationException {
        public AccessDeniedException(String message) {
            super(message);
        }

        public AccessDeniedException(String message, String state) {
            super(message, state);
        }

        @Override
        protected String getPrefix() {
            return "HTTP Access Denied";
        }
    }

    public static class AuthenticationFailedException
    extends AuthenticationException {
        public AuthenticationFailedException(String message) {
            super(message);
        }

        public AuthenticationFailedException(String message, String state) {
            super(message, state);
        }

        @Override
        protected String getPrefix() {
            return "HTTP Authentication Failed Exception";
        }
    }

    public static class UnauthorizedException
    extends AuthenticationException {
        public UnauthorizedException(String message) {
            super(message);
        }

        public UnauthorizedException(String message, String state) {
            super(message, state);
        }

        @Override
        protected String getPrefix() {
            return "HTTP Unauthorized Exception";
        }
    }

    public static class AuthenticationException
    extends FabricException {
        private String state = "0000";

        public AuthenticationException(String message) {
            this(message, "0000");
        }

        public AuthenticationException(String message, String state) {
            super(message);
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }

    public static class AuthenticationExceptionState {
        public static final String RUNTIME_AUTH_FAILED = "7001";
        public static final String ACCESS_DENIED_TO_REALM = "7002";
        public static final String UNKNOWN_OR_MISSING_SESSION_ID = "7003";
        public static final String WRONG_AUTH_TYPE = "7004";
        public static final String MISSING_AUTH_HEADER = "7005";
        public static final String INVALID_AUTH_HEADER = "7006";
        public static final String NONCE_IS_MISSING_OR_INVALID = "7007";
    }
}

