/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.BasicAuthenticator;
import com.streamscape.sef.network.http.server.authentication.DelegateAuthenticator;
import com.streamscape.sef.network.http.server.authentication.DigestAuthenticator;
import com.streamscape.sef.network.http.server.authentication.DropBoxResourceAuthenticator;
import com.streamscape.sef.network.http.server.authentication.OAuth2Authenticator;
import com.streamscape.sef.network.http.server.authentication.RealmAuthenticator;
import com.streamscape.sef.network.http.server.authentication.RealmManager;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.authentication.XResourceAuthenticator;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.authentication.delegate.DelegateAuthenticationProviderManager;
import com.streamscape.sef.network.http.server.authentication.jaxrs.ApiKeyConfigurator;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.OAuthAuthorizeServlet;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.OAuthRevokeServlet;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.OAuthTokenServlet;
import com.streamscape.sef.network.http.server.config.HTTPAuthenticationType;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviderForFabric;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviderForRest;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviders;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class AuthenticationManager {
    private HTTPAcceptor acceptor;
    private RealmManager realmManager;
    private RealmAuthenticator realmAuthenticator;
    private RuntimeAuthenticator runtimeAuthenticator;
    private FabricConnectionsProviders connectionsProviders;
    private FabricConnectionsProvider connectionsProviderForFabric;
    private FabricConnectionsProvider connectionsProviderForRest;
    private AbstractAuthenticator commonAuthenticator;
    private AbstractAuthenticator xResourceAuthenticator;
    private AbstractAuthenticator httpAuthenticator;
    private DelegateAuthenticator delegateAuthenticator;
    private AbstractAuthenticator dropBoxResourceAuthenticator;
    private OAuthTokenProvider oAuthTokenProvider;
    private TokensCleaner tokensCleaner;
    private DelegateAuthenticationProviderManager delegateAuthenticationProviderManager;

    public AuthenticationManager(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void start() throws Exception {
        this.realmManager = new RealmManager(this.acceptor);
        this.realmAuthenticator = new RealmAuthenticator(this.realmManager);
        this.runtimeAuthenticator = new RuntimeAuthenticator(this.acceptor.getRuntimeContext());
        this.connectionsProviders = new FabricConnectionsProviders();
        if (this.acceptor.getConfiguration().getAuthenticationType() == null) {
            this.acceptor.getConfiguration().setAuthenticationType(HTTPAuthenticationType.BASIC);
        }
        if (this.acceptor.getConfiguration().getAuthenticationType() == HTTPAuthenticationType.BASIC) {
            this.httpAuthenticator = this.commonAuthenticator = new BasicAuthenticator();
        } else if (this.acceptor.getConfiguration().getAuthenticationType() == HTTPAuthenticationType.DIGEST) {
            this.httpAuthenticator = this.commonAuthenticator = new DigestAuthenticator();
        } else if (this.acceptor.getConfiguration().getAuthenticationType() == HTTPAuthenticationType.OAUTH2) {
            if (this.acceptor.getConfiguration().getSessionAuthentication()) {
                throw new IllegalArgumentException("Invalid HTTP acceptor configuration: parameter 'sessionAuthentication' can be enabled only with BASIC/DIGEST authentication types.");
            }
            this.oAuthTokenProvider = new OAuthTokenProvider();
            this.oAuthTokenProvider.setConfiguration(this.acceptor.getConfiguration());
            this.oAuthTokenProvider.setFabricConnectionsProviders(this.connectionsProviders);
            this.commonAuthenticator = new OAuth2Authenticator(this.oAuthTokenProvider, JettyAdvancedProperties.build(this.acceptor.getConfiguration()).getBooleanProperty("jetstream.oauth2.share.token.between.sessions"));
            this.httpAuthenticator = new BasicAuthenticator();
        }
        if (this.acceptor.getConfiguration().getSessionAuthentication()) {
            this.commonAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
            this.commonAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
            this.commonAuthenticator = new XSessionAuthenticator(this.commonAuthenticator, this.acceptor.getRuntimeContext().getHTTPAuthenticationManager().getApiKeyManager().getApiKeyTokenAuthenticatorService());
            this.httpAuthenticator = new BasicAuthenticator();
        }
        if (this.acceptor.getConfiguration().getOAuthDelegates() != null && this.acceptor.getConfiguration().getOAuthDelegates().size() > 0) {
            this.delegateAuthenticationProviderManager = new DelegateAuthenticationProviderManager();
            this.delegateAuthenticationProviderManager.setConfiguration(this.acceptor.getConfiguration());
            this.delegateAuthenticationProviderManager.setFabricConnectionsProviders(this.connectionsProviders);
            this.delegateAuthenticationProviderManager.start(this.acceptor.getHTTPAcceptorFactory().getDelegateAuthenticationManager(), this.acceptor.getRuntimeContext());
            this.delegateAuthenticator = new DelegateAuthenticator(this.delegateAuthenticationProviderManager);
            this.delegateAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
            this.delegateAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
        }
        this.commonAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
        this.commonAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
        this.xResourceAuthenticator = new XResourceAuthenticator();
        this.xResourceAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
        this.xResourceAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
        this.dropBoxResourceAuthenticator = new DropBoxResourceAuthenticator(this.commonAuthenticator);
        this.dropBoxResourceAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
        this.dropBoxResourceAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
        this.httpAuthenticator.setRealmAuthenticator(this.realmAuthenticator);
        this.httpAuthenticator.setRuntimeAuthenticator(this.runtimeAuthenticator);
        if (this.oAuthTokenProvider != null || this.delegateAuthenticationProviderManager != null) {
            this.tokensCleaner = new TokensCleaner();
            this.tokensCleaner.start();
        }
        this.connectionsProviderForFabric = new FabricConnectionsProviderForFabric(this.acceptor, this.httpAuthenticator, this.commonAuthenticator);
        this.connectionsProviderForRest = new FabricConnectionsProviderForRest(this.acceptor);
        this.connectionsProviders.register(this.connectionsProviderForFabric);
        this.connectionsProviders.register(this.connectionsProviderForRest);
    }

    public void initServlets(ServletContextHandler context) {
        if (this.acceptor.getConfiguration().getAuthenticationType() == HTTPAuthenticationType.OAUTH2) {
            context.addServlet(OAuthTokenServlet.class, "/security/oauth2/token");
            context.addServlet(OAuthAuthorizeServlet.class, "/security/oauth2/authorize");
            context.addServlet(OAuthRevokeServlet.class, "/security/oauth2/revoke");
            context.getServletContext().setAttribute(OAuthTokenProvider.ATTRIBUTE, (Object)this.oAuthTokenProvider);
        }
        context.getServletContext().setAttribute(RuntimeAuthenticator.ATTRIBUTE, (Object)this.runtimeAuthenticator);
        new ApiKeyConfigurator().configure(context, this.acceptor.getRuntimeContext());
        if (this.delegateAuthenticationProviderManager != null) {
            this.delegateAuthenticationProviderManager.initServlets(context);
        }
    }

    public void stop() {
        if (this.connectionsProviders != null) {
            this.connectionsProviders.closeAllConnections();
        }
        if (this.tokensCleaner != null) {
            this.tokensCleaner.stop();
        }
    }

    public Authenticator getAuthenticator(HttpServletRequest request) {
        if (AuthenticationHelper.isApiKeySwaggerMetadataRequest(request) || AuthenticationHelper.isDropBoxSwaggerMetadataRequest(request) || AuthenticationHelper.isOAuth2Request(request) || AuthenticationHelper.isDelegateRequest(request)) {
            return Authenticator.NO_NEED;
        }
        if (DelegateAuthenticationProviderManager.isDelegateAuthenticationRequest(request) && this.delegateAuthenticator != null) {
            return this.delegateAuthenticator;
        }
        if (this.xResourceAuthenticator != null && this.xResourceAuthenticator.containsAuthentication(request)) {
            return this.xResourceAuthenticator;
        }
        if (this.dropBoxResourceAuthenticator != null && this.dropBoxResourceAuthenticator.containsAuthentication(request)) {
            return this.dropBoxResourceAuthenticator;
        }
        if (this.acceptor.getConfiguration().getAuthenticationType() == HTTPAuthenticationType.OAUTH2) {
            if (AuthenticationHelper.isSorRequest(request) || AuthenticationHelper.isSwaggerRequest(request)) {
                return this.httpAuthenticator;
            }
            return this.commonAuthenticator;
        }
        return this.commonAuthenticator;
    }

    public FabricConnectionsProvider getFabricConnectionsProvider(HttpServletRequest request) {
        if (AuthenticationHelper.isFabricRequest(request) || AuthenticationHelper.isDropBoxRequest(request) && request.getParameter("FabricSession") != null || AuthenticationHelper.isOdataRequest(request) && this.connectionsProviderForFabric.getConnection(request.getSession(true).getId()) != null) {
            return this.connectionsProviderForFabric;
        }
        return this.connectionsProviderForRest;
    }

    public FabricConnectionsProviders getFabricConnectionsProviders() {
        return this.connectionsProviders;
    }

    public RealmManager getRealmManager() {
        return this.realmManager;
    }

    private class TokensCleaner
    extends MonitorDaemonWorker {
        protected TokensCleaner() throws FabricException {
            super("JETTY:Tokens.Cleaner", "Thread to clear expired tokens for Jetty acceptor '" + AuthenticationManager.this.acceptor.getConfiguration().getName() + "'.", 10000L);
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            if (AuthenticationManager.this.oAuthTokenProvider != null) {
                AuthenticationManager.this.oAuthTokenProvider.removeExpired();
            }
            if (AuthenticationManager.this.delegateAuthenticationProviderManager != null) {
                AuthenticationManager.this.delegateAuthenticationProviderManager.removeExpired();
            }
        }
    }
}

