/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;

public class AuthenticationHelper {
    private static Method accessMethod = null;

    public static boolean isSecurityRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/security");
    }

    public static boolean isFabricRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/fabric");
    }

    public static boolean isSorRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/sor");
    }

    public static boolean isSorQuiltRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/sorquilt");
    }

    public static boolean isSorLoginRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && (request.getRequestURI().toLowerCase().startsWith("/sor/login") || request.getRequestURI().toLowerCase().startsWith("/sorquilt/login"));
    }

    public static boolean isSwaggerClientGenRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/swagger/v2/client/gen");
    }

    public static boolean isSwaggerRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/swagger/v2");
    }

    public static boolean isSwaggerMetadataRequest(HttpServletRequest request) {
        return AuthenticationHelper.isSwaggerRequest(request) && (request.getRequestURI().toLowerCase().endsWith("swagger.json") || request.getRequestURI().toLowerCase().endsWith("swagger.yaml"));
    }

    public static boolean isApiKeyRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/security/apikey");
    }

    public static boolean isApiKeySwaggerMetadataRequest(HttpServletRequest request) {
        return AuthenticationHelper.isApiKeyRequest(request) && (request.getRequestURI().toLowerCase().endsWith("swagger.json") || request.getRequestURI().toLowerCase().endsWith("swagger.yaml"));
    }

    public static boolean isApiKeyTokenAuthorizeNativeRequest(HttpServletRequest request) {
        return AuthenticationHelper.isApiKeyRequest(request) && request.getRequestURI().toLowerCase().endsWith("/token/authorize/native");
    }

    public static boolean isDropBoxSwaggerMetadataRequest(HttpServletRequest request) {
        return AuthenticationHelper.isDropBoxRequest(request) && (request.getRequestURI().toLowerCase().endsWith("swagger.json") || request.getRequestURI().toLowerCase().endsWith("swagger.yaml"));
    }

    public static boolean isOdataMetadataRequest(HttpServletRequest request) {
        int j;
        int i;
        if (!AuthenticationHelper.isOdataRequest(request)) {
            return false;
        }
        String uri = request.getRequestURI().toLowerCase().substring("/odata/v4".length());
        if (uri.length() == 0) {
            return true;
        }
        if (request.getRequestURI().toLowerCase().endsWith("$metadata")) {
            return true;
        }
        for (i = 0; i < uri.length() && uri.charAt(i) == '/'; ++i) {
        }
        for (j = uri.length() - 1; j >= 0 && uri.charAt(j) == '/'; --j) {
        }
        if (i >= j) {
            return true;
        }
        if ((uri = uri.substring(i, j + 1).trim()).startsWith("(S(")) {
            i = uri.indexOf("))");
            j = uri.indexOf("/");
            if (j < i) {
                return false;
            }
            uri = uri.substring(i + 2);
            for (j = i + 2; j < uri.length() && uri.charAt(j) == '/'; ++j) {
            }
            uri = j == uri.length() ? "" : uri.substring(j + 2);
        }
        return uri.length() == 0 || uri.indexOf("/") == -1;
    }

    public static String getRequestContextPath(HttpServletRequest request) {
        if (AuthenticationHelper.isFabricRequest(request)) {
            return "/fabric";
        }
        if (AuthenticationHelper.isDropBoxRequest(request)) {
            return "/dropbox";
        }
        String uri = request.getRequestURI();
        if (uri.startsWith("/exchange")) {
            return "/exchange";
        }
        if (uri.startsWith("/repository")) {
            return "/repository";
        }
        if (uri.startsWith("/sor")) {
            return "/sor";
        }
        if (uri.startsWith("/service")) {
            return "/service";
        }
        if (uri.startsWith("/ds")) {
            return "/ds";
        }
        if (uri.startsWith("/odata/v4")) {
            return "/odata/v4";
        }
        return "";
    }

    public static boolean isDropBoxRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().startsWith("/dropbox");
    }

    public static boolean isOdataRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().toLowerCase().startsWith("/odata/v4");
    }

    static boolean isOAuth2Request(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().startsWith("/security/oauth2");
    }

    static boolean isDelegateRequest(HttpServletRequest request) {
        return request.getRequestURI() != null && request.getRequestURI().startsWith("/security/delegate/");
    }

    static boolean isAnonymousRequest(HttpServletRequest request) {
        return request.getParameter("anonymous") != null;
    }

    static boolean isAnonymousRealm(RealmInfo realmInfo) {
        return realmInfo != null && realmInfo.checkUser("anonymous");
    }

    public static boolean isAuthenticationRequired(HttpServletRequest request) {
        return AuthenticationHelper.isApiKeyRequest(request) && !AuthenticationHelper.isApiKeySwaggerMetadataRequest(request) && !AuthenticationHelper.isApiKeyTokenAuthorizeNativeRequest(request);
    }

    public static void touchSession(HttpSession session) {
        AuthenticationHelper.touchSession(session, System.currentTimeMillis());
    }

    public static void touchSession(HttpSession session, long time) {
        if (session instanceof AbstractSessionManager.SessionIf) {
            try {
                accessMethod.invoke((Object)((AbstractSessionManager.SessionIf)session).getSession().getSession(), time);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Trace.logError(AuthenticationHelper.class, "Failed to touch session.");
                Trace.logException(AuthenticationHelper.class, e, true);
            }
        }
    }

    static {
        try {
            accessMethod = AbstractSession.class.getDeclaredMethod("access", Long.TYPE);
            accessMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

