/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication;

import com.streamscape.Trace;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractWwwAuthenticator
extends AbstractAuthenticator {
    @Override
    protected HTTPCredentials obtainCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String authorizationHeader = null;
        boolean isAuthInfoFromQuery = false;
        int authorizationIndex = this.getAuthorizationIndex(request);
        if (authorizationIndex != -1) {
            String query = request.getQueryString();
            int endPos = query.indexOf(38, authorizationIndex);
            if (endPos == -1) {
                endPos = query.length();
            }
            authorizationHeader = query.substring(authorizationIndex, endPos);
            authorizationHeader = FabricHTTPRequest.replaceSpecialSymbols(authorizationHeader);
            boolean bl = isAuthInfoFromQuery = !AuthenticationHelper.isSwaggerRequest(request);
        }
        if (authorizationHeader == null) {
            authorizationHeader = request.getHeader("Authorization");
            isAuthInfoFromQuery = false;
        }
        if (isAuthInfoFromQuery && AuthenticationHelper.isAnonymousRequest(request) || authorizationHeader == null && AuthenticationHelper.isAnonymousRealm(this.realmAuthenticator.getManager().getRealmInfoForRequest(request))) {
            return HTTPCredentials.buildDigest("anonymous", "anonymous");
        }
        try {
            if (authorizationHeader == null || authorizationHeader.isEmpty() || !authorizationHeader.contains(this.getAuthInfoDelimiter(isAuthInfoFromQuery))) {
                throw new Authenticator.UnauthorizedException("Missing Authorization header.", "7005");
            }
            String httpAuthType = authorizationHeader.substring(0, authorizationHeader.indexOf(this.getAuthInfoDelimiter(isAuthInfoFromQuery)));
            String authInfo = authorizationHeader.substring(authorizationHeader.indexOf(this.getAuthInfoDelimiter(isAuthInfoFromQuery)) + 1);
            return this.obtainCredentialsFromAuthInfo(request, httpAuthType, authInfo, isAuthInfoFromQuery);
        }
        catch (Authenticator.UnauthorizedException exception) {
            Trace.logDebug(this, exception.toString());
            this.onUnauthorized(request, response, isAuthInfoFromQuery);
            return null;
        }
    }

    private int getAuthorizationIndex(HttpServletRequest request) {
        String query;
        if ((AuthenticationHelper.isFabricRequest(request) || AuthenticationHelper.isDropBoxRequest(request) || AuthenticationHelper.isOdataRequest(request) || AuthenticationHelper.isSwaggerRequest(request) || AuthenticationHelper.isSecurityRequest(request)) && (query = request.getQueryString()) != null) {
            String authorizationParameter = "Authorization=";
            int pos = query.indexOf("Authorization=");
            if (pos != -1) {
                return pos + "Authorization=".length();
            }
        }
        return -1;
    }

    protected boolean isAuthInfoFromQuery(HttpServletRequest request) {
        return this.getAuthorizationIndex(request) != -1;
    }

    protected String getAuthInfoDelimiter(boolean isAuthInfoFromQuery) {
        return isAuthInfoFromQuery ? ":" : " ";
    }

    @Override
    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        if (this.isAuthInfoFromQuery(request)) {
            this.reply(request, response, "WWW-Authenticate: FAILED");
        } else {
            this.reply(request, response, exception);
        }
    }

    @Override
    protected void onSessionExpired(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        if (this.isAuthInfoFromQuery(request)) {
            this.reply(request, response, "WWW-Authenticate: SESSION_EXPIRED");
        } else {
            this.reply(request, response);
        }
    }

    private void onUnauthorized(HttpServletRequest request, HttpServletResponse response, boolean isAuthInfoFromQuery) throws IOException {
        if (isAuthInfoFromQuery) {
            this.reply(request, response, "WWW-Authenticate: " + this.getAuthRequest(request, isAuthInfoFromQuery));
        } else {
            this.reply(request, response);
        }
    }

    protected void reply(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.reply(request, response, (Authenticator.AuthenticationFailedException)null);
    }

    protected void reply(HttpServletRequest request, HttpServletResponse response, Authenticator.AuthenticationFailedException exception) throws IOException {
        String authreq = this.getAuthRequest(request, false);
        response.setHeader("WWW-Authenticate", authreq);
        if (exception != null) {
            response.sendError(401, exception.getMessage());
        } else {
            response.sendError(401);
        }
        Trace.logDebug(this, "Send SC_UNAUTHORIZED: " + authreq);
    }

    private void reply(HttpServletRequest request, HttpServletResponse response, String authRequest) throws IOException {
        Trace.logDebug(this, "Send UNAUTHORIZED response to jsClient: " + (String)authRequest);
        String callback = request.getParameter("callback");
        if (callback != null) {
            authRequest = callback + "('" + (String)authRequest + "');";
            response.setContentType("text/javascript; charset=UTF-8");
        } else {
            response.setContentType("text/plain; charset=UTF-8");
        }
        response.setStatus(200);
        response.setContentLength(((String)authRequest).length());
        response.getOutputStream().print((String)authRequest);
        response.getOutputStream().close();
        request.getInputStream().close();
    }

    @Override
    public boolean containsAuthentication(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        return header != null && header.trim().toLowerCase().startsWith(this.getAuthType());
    }

    protected abstract HTTPCredentials obtainCredentialsFromAuthInfo(HttpServletRequest var1, String var2, String var3, boolean var4) throws Authenticator.UnauthorizedException;

    protected abstract String getAuthRequest(HttpServletRequest var1, boolean var2);

    protected abstract String getAuthType();
}

